% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ularcirc_miRNA.R
\name{miR_binding_site_Analysis}
\alias{miR_binding_site_Analysis}
\title{miR_binding_site_Analysis
This function analyses a genomic (RNA or DNA) sequence for matching miRNA seed sequences.}
\usage{
miR_binding_site_Analysis(
  Sequence_to_examine,
  species_code,
  seed_length = 6,
  seed_start = 2,
  selected_miRs = NULL,
  rev_comp = TRUE,
  mirbaselocalDir = tempdir()
)
}
\arguments{
\item{Sequence_to_examine}{: RNA/DNA Sequence to be analysed for miRNA binding sites. Format can be a character string or Biostrings formatted object.}

\item{seed_length}{: Length of seed sequence of a miRNA (default 6).}

\item{seed_start}{: Starting position of seed sequence relative to mature miRNA sequence (default 2).}

\item{selected_miRs}{: names of miRNA.}

\item{rev_comp}{: Should function perform Reverse complement of Sequence_to_examine (default TRUE).}

\item{mirbaselocalDir}{: Directory where miRbase files are located. If files are not detected will download requested files from mirBase}

\item{speciesCode}{: Three letter code of species (eg human = hsa). Used to subset species miRbase entries}
}
\description{
miR_binding_site_Analysis
This function analyses a genomic (RNA or DNA) sequence for matching miRNA seed sequences.
}
\details{
The function will convert T to U and scan for matching miRNA seed sequences. 
Will return a list containing the following outputs: 
          SeedMatchResult  - counts of all seeds. Value of -1 indicates seed not detected. 
          Total_miR_number - the total number of miRNA scanned against. 
          miR_Seed_Lookup  - data frame of all miRNA seeds scanned against.
}
\examples{
    Seq <- circSequence()
    output <- miR_binding_site_Analysis(Sequence_to_examine = Seq, species_code = "hsa", rev_comp = TRUE)

    # display frequency of seed sequences.
    # Values of -1 do not occur
    head(output$SeedMatchResult)   

}
