% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tronco.R
\name{tronco.bootstrap}
\alias{tronco.bootstrap}
\title{tronco bootstrap}
\usage{
tronco.bootstrap(
  reconstruction,
  type = "non-parametric",
  nboot = 100,
  cores.ratio = 1,
  silent = FALSE
)
}
\arguments{
\item{reconstruction}{The output of tronco.capri or
tronco.caprese}

\item{type}{Parameter to define the type of sampling
to be performed, e.g., non-parametric for uniform sampling.}

\item{nboot}{Number of bootstrap sampling to be performed
when estimating the model confidence.}

\item{cores.ratio}{Percentage of cores to use
coresRate * (numCores - 1)}

\item{silent}{A parameter to disable/enable verbose messages.}
}
\value{
A TRONCO compliant object with reconstructed model
}
\description{
Bootstrap a reconstructed progression model. For details and examples
regarding the statistical assesment of an inferred model,
we refer to the Vignette Section 7.
}
\examples{
data(test_model)
boot = tronco.bootstrap(test_model, nboot = 1, cores.ratio = 0)

}
