% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.functions.R
\name{as.adj.matrix}
\alias{as.adj.matrix}
\title{as.adj.matrix}
\usage{
as.adj.matrix(x, events = as.events(x), models = names(x$model), type = "fit")
}
\arguments{
\item{x}{A TRONCO model.}

\item{events}{A subset of events as of \code{as.events(x)}, all by default.}

\item{models}{A subset of reconstructed models, all by default.}

\item{type}{Either the prima facie ('pf') or the post-regularization ('fit') matrix, 'fit' by default.}
}
\value{
The adjacency matrix of a TRONCO model.
}
\description{
Extract the adjacency matrix of a TRONCO model. The matrix is indexed with colnames/rownames which 
represent genotype keys - these can be resolved with function \code{keysToNames}. It is possible to
specify a subset of events to build the matrix, a subset of models if multiple reconstruction have
been performed. Also, either the prima facie matrix or the post-regularization matrix can be extracted.
}
\examples{
data(test_model)
as.adj.matrix(test_model)
as.adj.matrix(test_model, events=as.events(test_model)[5:15,])
as.adj.matrix(test_model, events=as.events(test_model)[5:15,], type='pf')

}
