% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_funcs.R
\name{import2dDataset}
\alias{import2dDataset}
\title{Import 2D-TPP dataset using a config table}
\usage{
import2dDataset(
  configTable,
  data,
  idVar = "representative",
  intensityStr = "sumionarea_protein_",
  fcStr = "rel_fc_protein_",
  nonZeroCols = "qssm",
  geneNameVar = "clustername",
  addCol = NULL,
  qualColName = "qupm",
  naStrs = c("NA", "n/d", "NaN"),
  concFactor = 1e+06,
  medianNormalizeFC = TRUE,
  filterContaminants = TRUE
)
}
\arguments{
\item{configTable}{character string of a file path to a config table}

\item{data}{possible list of datasets from different MS runs 
corresponding to a 2D-TPP dataset, circumvents loading datasets 
referencend in config table, default is NULL}

\item{idVar}{character string indicating which data column provides the 
unique identifiers for each protein.}

\item{intensityStr}{character string indicating which columns contain 
raw intensities measurements}

\item{fcStr}{character string indicating which columns contain the actual 
fold change values. Those column names containing the suffix \code{fcStr} 
will be regarded as containing fold change values.}

\item{nonZeroCols}{column like default qssm that should be imported and
requested to be non-zero in analyzed data}

\item{geneNameVar}{character string of the column name that describes
the gene name of a given protein in the raw data files}

\item{addCol}{character string indicating additional column to import}

\item{qualColName}{character string indicating which column can be used for 
additional quality criteria when deciding between different non-unique 
protein identifiers.}

\item{naStrs}{character vector indicating missing values in the data table. 
When reading data from file, this value will be passed on to the argument 
\code{na.strings} in function \code{read.delim}.}

\item{concFactor}{numeric value that indicates how concentrations need to 
be adjusted to yield total unit e.g. default mmol - 1e6}

\item{medianNormalizeFC}{perform median normalization (default: TRUE).}

\item{filterContaminants}{boolean variable indicating whether data 
should be filtered to exclude contaminants (default: TRUE).}
}
\value{
tidy data frame representing a 2D-TPP dataset
}
\description{
Import 2D-TPP dataset using a config table
}
\examples{
data("config_tab")
data("raw_dat_list")
import_df <- import2dDataset(configTable = config_tab, 
                             data = raw_dat_list,
                             idVar = "protein_id",
                             intensityStr = "signal_sum_",
                             fcStr = "rel_fc_",
                             nonZeroCols = "qusm",
                             geneNameVar = "gene_name",
                             addCol = NULL,
                             qualColName = "qupm",
                             naStrs = c("NA", "n/d", "NaN"),
                             concFactor = 1e6,
                             medianNormalizeFC = TRUE,
                             filterContaminants = TRUE)

}
