% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debris.R
\name{findDebrisCells}
\alias{findDebrisCells}
\alias{findDebrisCells,matrix-method}
\alias{findDebrisCells,sfc-method}
\alias{findDebrisCells,sf-method}
\alias{findDebrisCells,SpatialExperiment-method}
\title{Identify cells in small bits outside the main piece of tissue}
\usage{
\S4method{findDebrisCells}{matrix}(
  x,
  max_cells = 5,
  distance_cutoff = 50,
  BNPARAM = NULL,
  BPPARAM = SerialParam()
)

\S4method{findDebrisCells}{sfc}(
  x,
  max_cells = 5,
  distance_cutoff = 50,
  BNPARAM = NULL,
  BPPARAM = SerialParam()
)

\S4method{findDebrisCells}{sf}(
  x,
  max_cells = 5,
  distance_cutoff = 50,
  BNPARAM = NULL,
  BPPARAM = SerialParam()
)

\S4method{findDebrisCells}{SpatialExperiment}(
  x,
  max_cells = 5,
  distance_cutoff = 50,
  BNPARAM = NULL,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{x}{Object with spatial coordinates of cells. Can be a
\code{SpatialExperiment} or \code{SpatialFeatureExperiment} object, a
matrix with 2 columns for x and y coordinates of cells, or a \code{sf} or
\code{sfc} object with cell geometries.}

\item{max_cells}{Maximum number of cells for a clump of cells to be
considered debris.}

\item{distance_cutoff}{Minimum distance of cell to the tissue for it to be
considered debris, in the same unit as in \code{x}.}

\item{BNPARAM}{A \code{\link[BiocNeighbors]{BiocNeighborParam}} object specifying the
algorithm to find k nearest neighbors and distance based neighbors with
\code{nn_method = "bioc"}. For distance based neighbors, only
\code{\link[BiocNeighbors]{KmknnParam}} and \code{\link[BiocNeighbors]{VptreeParam}} are applicable.}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam}} object for multithreading.
Only used for k nearest neighbor and distance based neighbor with
\code{nn_method = "bioc"}.}
}
\value{
Depends on the method:
\describe{
\item{Spatial(Feature)Experiment}{The same object with a logical column 
"is_debris" added to \code{colData}.}
\item{Matrix and \code{sf(c)}}{A logical vector indicating whether each cell
is debris.}
}
}
\description{
This is used for quality control (QC), as the small bits are likely to be low
quality technical artifacts and are not informative to spatial analyses.
Please confirm the quality of those cells by checking the histology image
with ImageJ or QuPath.
}
\details{
How this function works: A distance-based spatial neighborhood graph is
computed, with \code{distance_cutoff} as the distance cutoff. Then disjoint
connected subgraphs are found. Cells in subgraphs with \code{max_cells} or
fewer cells are considered debris.
}
