% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimGeometries.R
\name{colGeometries}
\alias{colGeometries}
\alias{colGeometry}
\alias{colGeometry<-}
\alias{colGeometries<-}
\alias{colGeometryNames}
\alias{colGeometryNames<-}
\alias{spotPoly}
\alias{spotPoly<-}
\alias{centroids}
\alias{centroids<-}
\alias{ROIPoly}
\alias{ROIPoly<-}
\alias{cellSeg}
\alias{cellSeg<-}
\alias{nucSeg}
\alias{nucSeg<-}
\title{Column geometry getters and setters}
\usage{
colGeometry(x, type = 1L, sample_id = 1L, withDimnames = TRUE)

colGeometry(
  x,
  type = 1L,
  sample_id = 1L,
  withDimnames = TRUE,
  translate = TRUE
) <- value

colGeometries(x, withDimnames = TRUE)

colGeometries(x, withDimnames = TRUE, translate = TRUE) <- value

colGeometryNames(x)

colGeometryNames(x) <- value

spotPoly(x, sample_id = 1L, withDimnames = TRUE)

spotPoly(x, sample_id = 1L, withDimnames = TRUE, translate = TRUE) <- value

centroids(x, sample_id = 1L, withDimnames = TRUE)

centroids(x, sample_id = 1L, withDimnames = TRUE, translate = TRUE) <- value

ROIPoly(x, sample_id = 1L, withDimnames = TRUE)

ROIPoly(x, sample_id = 1L, withDimnames = TRUE, translate = TRUE) <- value

cellSeg(x, sample_id = 1L, withDimnames = TRUE)

cellSeg(x, sample_id = 1L, withDimnames = TRUE, translate = TRUE) <- value

nucSeg(x, sample_id = 1L, withDimnames = TRUE)

nucSeg(x, sample_id = 1L, withDimnames = TRUE, translate = TRUE) <- value
}
\arguments{
\item{x}{A \code{SpatialFeatureExperiment} object.}

\item{type}{An integer specifying the index or string specifying the name of
the *Geometry to query or replace. If missing, then the first item in the
*Geometries will be returned or replaced.}

\item{sample_id}{Sample ID to get or set geometries.}

\item{withDimnames}{Logical. If \code{TRUE}, then the dimnames (colnames or
rownames) of the gene count matrix should correspond to row names of the
\code{sf} data frames of interest.}

\item{translate}{Logical. Only used if \code{\link{removeEmptySpace}} has
been run of the SFE object. If that's the case, this argument indicates
whether the new value to be assigned to the geometry is in the coordinates
prior to removal of empty space so it should be translated to match the new
coordinates after removing empty space. Default to \code{TRUE}.}

\item{value}{Value to set. For \code{dimGeometry}, must be a \code{sf} data
frame with the same number of rows as size in the dimension of interest, or
an ordinary data frame that can be converted to such a \code{sf} data frame
(see \code{\link{df2sf}}). For \code{dimGeometries}, must be a list of such
\code{sf} or ordinary data frames.}
}
\description{
\code{colGeometries} are geometries that correspond to columns of the gene
count matrix, such as Visium spots or cells. Same as \code{dimGeometry(x,
MARGIN = 2L, ...)}, with convenience wrappers for getters and setters of
special geometries:
\describe{
\item{spotPoly}{Polygons of spots from technologies such as Visium, ST, and
slide-seq, which do not correspond to cells. Centroids of the polygons are
stored in \code{spatialCoords} of the underlying \code{SpatialExperiment}
object.}
\item{ROIPoly}{Polygons of regions of interest (ROIs) from
technologies such as laser capture microdissection (LCM) and GeoMX DSP. These
should correspond to columns of the gene count matrix.}
\item{cellSeg}{Cell segmentation polygons. If the columns of the gene count
matrix are single cells, then this is stored in \code{colGeometries}.
Otherwise, this is stored in \code{\link{annotGeometries}}.}
\item{nucSeg}{Similar to \code{cellSeg}, but for nuclei rather than whole
cell.}}
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData(dataset = "small")
cgs <- colGeometries(sfe)
spots <- spotPoly(sfe)
}
\seealso{
[dimGeometries()], [rowGeometries()]
}
\concept{Getters and setters}
