% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimGeometries.R
\name{rowGeometries}
\alias{rowGeometries}
\alias{rowGeometry}
\alias{rowGeometry<-}
\alias{rowGeometries<-}
\alias{rowGeometryNames}
\alias{rowGeometryNames<-}
\alias{txSpots}
\alias{txSpots<-}
\title{Row geometry getters and setters}
\usage{
rowGeometry(x, type = 1L, sample_id = 1L, withDimnames = TRUE)

rowGeometry(
  x,
  type = 1L,
  sample_id = 1L,
  withDimnames = TRUE,
  partial = FALSE,
  translate = TRUE
) <- value

rowGeometries(x, sample_id = "all", withDimnames = TRUE)

rowGeometries(
  x,
  sample_id = "all",
  withDimnames = TRUE,
  partial = FALSE,
  translate = TRUE
) <- value

rowGeometryNames(x)

rowGeometryNames(x) <- value

txSpots(x, sample_id = 1L, withDimnames = TRUE)

txSpots(
  x,
  sample_id = 1L,
  withDimnames = TRUE,
  partial = FALSE,
  translate = TRUE
) <- value
}
\arguments{
\item{x}{A \code{SpatialFeatureExperiment} object.}

\item{type}{An integer specifying the index or string specifying the name of
the *Geometry to query or replace. If missing, then the first item in the
*Geometries will be returned or replaced.}

\item{sample_id}{Sample ID to get or set geometries.}

\item{withDimnames}{Logical. If \code{TRUE}, then the dimnames (colnames or
rownames) of the gene count matrix should correspond to row names of the
\code{sf} data frames of interest.}

\item{partial}{In setters, if a \code{rowGeometry} of the same name exists,
whether to only replace the rows present in \code{value}.}

\item{translate}{Logical. Only used if \code{\link{removeEmptySpace}} has
been run of the SFE object. If that's the case, this argument indicates
whether the new value to be assigned to the geometry is in the coordinates
prior to removal of empty space so it should be translated to match the new
coordinates after removing empty space. Default to \code{TRUE}.}

\item{value}{Value to set. For \code{dimGeometry}, must be a \code{sf} data
frame with the same number of rows as size in the dimension of interest, or
an ordinary data frame that can be converted to such a \code{sf} data frame
(see \code{\link{df2sf}}). For \code{dimGeometries}, must be a list of such
\code{sf} or ordinary data frames.}
}
\description{
\code{rowGeometries} are geometries that corresponding to rows of the gene
count matrix, such as smFISH transcript spots. The \code{txSpots()} function
is a convenience wrapper for transcript spots, although this entirely depends
on the \code{rowGeometry} being named \code{txSpots}.
}
\details{
When there are multiple samples in the SFE object, \code{rowGeometries} for
each sample has the \code{sample_id} appended to the name of the geometry.
For example, if the name is \code{txSpots} and the sample ID is
\code{sample01}, then the actual name of the \code{rowGeometry} is
\code{txSpots_sample01}. In the getter, one can still specify
\code{rowGeometry(sfe, "txSpots", sample_id = "sample01")}.

Appending the \code{sample_id} is unnecessary when there is only one sample,
but \code{sample_id} will be appended when to SFE objects are combined with
\code{cbind}. It is necessary to distinguish bewteen different samples
because they can have overlapping coordinate values.
}
\examples{
library(SFEData)
library(RBioFormats)
fp <- tempfile()
dir_use <- XeniumOutput("v2", file_path = fp)
# RBioFormats issue
try(sfe <- readXenium(dir_use, add_molecules = TRUE))
sfe <- readXenium(dir_use, add_molecules = TRUE)
rowGeometries(sfe)
rowGeometryNames(sfe)
tx <- rowGeometry(sfe, "txSpots")
txSpots(sfe)
unlink(dir_use, recursive = TRUE)
}
\seealso{
[dimGeometries()], [colGeometries()]
}
\concept{Getters and setters}
