% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry_operation.R
\name{removeEmptySpace}
\alias{removeEmptySpace}
\title{Remove empty space}
\usage{
removeEmptySpace(sfe, sample_id = "all")
}
\arguments{
\item{sfe}{An SFE object.}

\item{sample_id}{Sample to remove empty space.}
}
\value{
An SFE object with empty space removed.
}
\description{
For each sample independently, all geometries and \code{spatialCoords} are
translated so the origin is at the minimum coordinates of the bounding box
of all geometries of the sample. This way coordinates of different samples
will be more comparable. This removes empty space in the images if present.
}
\note{
Unlike other functions in this package, this function operates on all
samples by default.
}
\examples{
library(SFEData)
library(SingleCellExperiment)
sfe <- McKellarMuscleData("full")
# Only keep spots on tissue
sfe <- sfe[, colData(sfe)$in_tissue]
# Move the coordinates of the tissue
sfe <- removeEmptySpace(sfe)
}
\concept{Geometric operations}
