% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry_operation.R
\name{annotPred}
\alias{annotPred}
\alias{annotNPred}
\title{Binary predicates for geometry of each cell/spot and annotation}
\usage{
annotPred(
  sfe,
  colGeometryName = 1L,
  annotGeometryName = 1L,
  sample_id = "all",
  pred = st_intersects,
  yx = FALSE
)

annotNPred(
  sfe,
  colGeometryName = 1L,
  annotGeometryName = 1L,
  sample_id = "all",
  pred = st_intersects
)
}
\arguments{
\item{sfe}{An SFE object.}

\item{colGeometryName}{Name of column geometry for the predicate.}

\item{annotGeometryName}{Name of annotation geometry for the predicate.}

\item{sample_id}{Which sample(s) to operate on. Can be "all" to indicate all
samples.}

\item{pred}{Predicate function to use, defaults to
\code{\link[sf]{st_intersects}}.}

\item{yx}{Whether to do \code{pred(y, x)} instead of \code{pred(x, y)}. For
symmetric predicates, the results should be the same. When x has a large
number of geometries and y has few, \code{pred(y, x)} is much faster than
\code{pred(x, y)} for \code{st_intersects}, \code{st_disjoint}, and
\code{st_is_within_distance}.}
}
\value{
For \code{annotPred}, a logical vector of the same length as the
  number of columns in the sample(s) of interest, with barcodes (or
  corresponding column names of sfe) as names. For \code{annotNPred}, a
  numeric vector of the same length as the number of columns in the sample(s)
  of interest with barcodes as names, indicating the number of geometries
  in the \code{annotGeometry} of interest returns TRUE for the predicate for
  each each geometry in the \code{colGeometry} of interest.
}
\description{
This function finds binary predicates for the geometry of each cell/spot
(i.e. \code{colGeometry}) and an annotation geometry for each sample. For
example, whether each Visium spot intersects with the tissue boundary in each
sample.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData("small")
# Whether each spot is in tissue
in_tissue <- annotPred(sfe, "spotPoly", annotGeometryName = "tissueBoundary")
# How many nuclei are there in each Visium spot
n_nuclei <- annotNPred(sfe, "spotPoly", annotGeometryName = "nuclei")
}
\seealso{
annotOp
}
\concept{Geometric operations}
