% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCSRNet-class.R, R/SCSRNoNet-class.R
\name{performInferences}
\alias{performInferences}
\alias{performInferences,SCSRNet-method}
\alias{performInferences,SCSRNoNet-method}
\title{Inference of ligand-receptor interactions based on regulation}
\usage{
\S4method{performInferences}{SCSRNet}(
  obj,
  autocrine = TRUE,
  paracrine = TRUE,
  selected.populations = NULL,
  funDiffExpr = NULL,
  subsample.size = 50,
  n.resample = 10,
  rank.p = 0.55,
  max.pval = 0.01,
  min.logFC = 1,
  min.LR.score = 0,
  neg.receptors = FALSE,
  pos.targets = FALSE,
  neg.targets = FALSE,
  min.t.logFC = 0.5,
  restrict.genes = NULL,
  use.full.network = FALSE,
  reference = c("REACTOME-GOBP", "REACTOME", "GOBP"),
  max.pw.size = 600,
  min.pw.size = 10,
  min.positive = 2,
  restrict.pw = NULL,
  with.complex = TRUE,
  fdr.proc = c("BH", "Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BY", "ABH",
    "TSBH"),
  verbose = FALSE
)

\S4method{performInferences}{SCSRNoNet}(
  obj,
  autocrine = TRUE,
  paracrine = TRUE,
  selected.populations = NULL,
  funDiffExpr = NULL,
  subsample.size = 50,
  n.resample = 10,
  max.pval = 0.01,
  min.logFC = 1,
  min.LR.score = 0,
  neg.receptors = FALSE,
  restrict.genes = NULL,
  fdr.proc = c("BH", "Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BY", "ABH",
    "TSBH"),
  verbose = FALSE
)
}
\arguments{
\item{obj}{A SCSRNoNet object.}

\item{autocrine}{A logical indicating whether autocrine interactions
should be inferred.}

\item{paracrine}{A logical indicating whether paracrine interactions
should be inferred.}

\item{selected.populations}{A vector of cell population names to
limit inferences to these very cell populations.}

\item{funDiffExpr}{An optional function to compute the differential
expression tables for each population. The function is called for
one population at a time, with the \code{SCSRNoNet} object and
the population name as parameters,
and it must return a \code{\link[BulkSignalR]{BSRClusterComp-class}}
object.}

\item{subsample.size}{The number of cells to sample from a given
population to estimate differential expression significance.}

\item{n.resample}{The number of times the sampling is performed.}

\item{rank.p}{A number between 0 and 1 defining the rank of the last
considered target genes (see BulkSignalR documentation).}

\item{max.pval}{The maximum P-value imposed to both the ligand
and the receptor.}

\item{min.logFC}{The minimum log2 fold-change allowed for
both the receptor and the ligand.}

\item{min.LR.score}{The minimum required LR-score.}

\item{neg.receptors}{A logical indicating whether receptors are only
allowed to be upregulated (FALSE), or up- and downregulated (TRUE).}

\item{pos.targets}{A logical imposing that all the network targets must
display positive logFC, i.e. logFC >= min.t.logFC.}

\item{neg.targets}{A logical imposing that all the network targets must
display negative logFC, i.e. logFC <= - min.t.logFC.}

\item{min.t.logFC}{The minimum log2 fold-change allowed for
targets in case pos.targets or neg.targets are used.}

\item{restrict.genes}{A list of gene symbols that restricts ligands and
receptors.}

\item{use.full.network}{A logical to avoid limiting the reference network
to the detected genes and use the whole reference network.}

\item{reference}{Which pathway reference should be used ("REACTOME"
for Reactome, "GOBP" for GO Biological Process,
or "REACTOME-GOBP" for both).}

\item{max.pw.size}{Maximum pathway size to consider from the pathway
reference.}

\item{min.pw.size}{Minimum pathway size to consider from the pathway
reference.}

\item{min.positive}{Minimum number of target genes to be found in a given
pathway.}

\item{restrict.pw}{A list of pathway IDs to restrict the application of
the function.}

\item{with.complex}{A logical indicating whether receptor co-complex
members should be included in the target genes.}

\item{fdr.proc}{The procedure for adjusting P-values according to
\code{\link[multtest]{mt.rawp2adjp}}.}

\item{verbose}{A logical activating reports on computation steps done.}
}
\value{
A SCSRNet object with inferences set.

A SCSRNoNet with inferences set.
}
\description{
This method computes all the autocrine and paracrine ligand-receptor
interactions. In addition, it is possible to restrict inferences to
autocrine or paracrine only, or do it for chosen cell populations.

This method computes all the autocrine and paracrine ligand-receptor
interactions. In addition, it is possible to restrict inferences to
autocrine or paracrine only, or do it for chosen cell populations.
}
\details{
The basis of the interaction inferences is the increased expression of
the ligand, the receptor, and the target genes below the receptor in
their respective cell populations. To determine differential expression
it is necessary to compare cell populations and to generate data.frames
representing gene differential expression. The data.frame format
is defined in \code{\link[BulkSignalR]{BSRClusterComp-class}} class.
A default procedure is provided for generating 
all the differential expression analyses, i.e.,
one per cell population comparing it to all the other cells. It relies
on Wilcoxon tests performed on a fixed number of cells per population
(\code{subsample.size} parameter) to avoid biases due to actual sizes. Such
sampling and significance analysis is performed \code{n.resample} times
and the median P-value is finally used.
It is possible to substitute a user-defined function for this purpose
in case a different notion of differential expression would be
preferred.

Once all the individual cell population differential analyses are done,
autocrine and paracrine ligand-receptor interactions are generated.

In addition to statistical significance estimated according to BulkSignalR
statistical model, we compute SingleCellSignalR original LR-score, based
on L and R cluster average expression.

The basis of the interaction inferences is the increased expression of
the ligand and the receptor in
their respective cell populations. To determine differential expression
it is necessary to compare cell populations and to generate data.frames
representing gene differential expression. The data.frame format
is defined in \code{\link[BulkSignalR]{BSRClusterComp-class}} class.
A default procedure is provided for generating all
the differential expression analyses, i.e.,
one per cell population comparing it to all the other cells. It relies
on Wilcoxon tests performed on a fixed number of cells per population
(\code{subsample.size} parameter) to avoid biases due to actual sizes. Such
sampling and significance analysis is performed \code{n.resample} times
and the median P-value is finally used.
It is possible to substitute a user-defined function for this purpose
in case a different notion of differential expression would be
preferred.

Once all the individual cell population differential analyses are done,
autocrine and paracrine ligand-receptor interactions are generated.

In addition to statistical significance estimated by taking the ligand
and the receptor P-values product, we compute SingleCellSignalR original
LR-score, based
on L and R cluster average expression.
}
\examples{
# prepare data
print("SCSRNet")
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrcn <- SCSRNet(mat,
    normalize = FALSE, method = "log-only",
    log.transformed = TRUE, populations = pop
)

if (FALSE){
# infer ligand-receptor interactions from the comparison
scsrcn <- performInferences(scsrcn,
    verbose = TRUE, min.logFC = 1e-10,
    max.pval = 1
)
}
data(example_dataset, package = "SingleCellSignalR")
print("performInferences")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrnn <- SCSRNoNet(mat,
    normalize = FALSE, method = "log-only",
    log.transformed = TRUE, populations = pop
)
# performInferences
if (FALSE) {
scsrnn <- performInferences(scsrnn,
    verbose = TRUE, ,
    min.logFC = 1e-10, max.pval = 1)
}
}
