% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_OpenSWATH_output.R
\name{reduce_OpenSWATH_output}
\alias{reduce_OpenSWATH_output}
\title{Reduce columns of OpenSWATH data}
\usage{
reduce_OpenSWATH_output(data, column.names = NULL)
}
\arguments{
\item{data}{A data frame containing SWATH data.}

\item{column.names}{A vector of column names that can be selected.}
}
\value{
Returns a data frame with the selected columns.
}
\description{
This function selects the columns from the standard OpenSWATH output to
column needed for MSstats, aLFQ and mapDIA.
}
\note{
A basic set of columns are defined in the function and are used if no column
  names are indicated.

The column.names can be omitted and then the following columns are
  selected that are needed for MSstats and mapDIA analysis: ProteinName,
  FullPeptideName, Sequence, Charge, aggr_Fragment_Annotation,
  aggr_Peak_Area, filename, m_score, decoy, Intensity, RT.
  This function should be ommitted if the data is analyzed afterwards with
  the aLFQ or imsbInfer package that needs further columns.
}
\examples{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 data.filtered <- reduce_OpenSWATH_output(data)
}
\author{
Peter Blattmann
}
