% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-mca.R
\name{runMCA}
\alias{runMCA}
\alias{runMCA,SingleCellExperiment-method}
\alias{runMCA,SingleCellExperiment}
\title{Run Multiple Correspondence Analysis}
\usage{
runMCA(
  data,
  assay.type = "logcounts",
  reduction.name = "MCA",
  ncomponents = 30,
  subset.row = NULL,
  subset.col = NULL,
  group.by.vars = NULL,
  consider.spcoord = FALSE,
  ...
)

\S4method{runMCA}{SingleCellExperiment}(
  data,
  assay.type = "logcounts",
  reduction.name = "MCA",
  ncomponents = 50,
  subset.row = NULL,
  subset.col = NULL,
  group.by.vars = NULL,
  consider.spcoord = FALSE,
  ...
)
}
\arguments{
\item{data}{a SingleCellExperiment object}

\item{assay.type}{which expressed data to be pulled to run,
default is \code{logcounts}.}

\item{reduction.name}{name of the reduction result, default is \code{MCA}.}

\item{ncomponents}{number of components to compute and store, default is 30.}

\item{subset.row}{Vector specifying the subset of features to be used for
dimensionality reduction. This can be a character vector of row names,
an integer vector of row indices or a logical vector, default is NULL, meaning
all features to be used for dimensionality reduction.}

\item{subset.col}{Vector specifying the subset of cells to be used for
dimensionality reduction. This can be a character vector of column names,
an integer vector of column indices or a logical vector, default is NULL, meaning
all cells to be used for dimensionality reduction.}

\item{group.by.vars}{character the name(s) of covariates that harmony will remove its
effect on the data, default is NULL.}

\item{consider.spcoord}{whether consider the spatial coords as the features of data
to run MCA, default is FALSE (TRUE is experimental).}

\item{...}{additional parameters, see also \code{RunHarmony}.}
}
\value{
a \linkS4class{SingleCellExperiment} and the reduction result of \code{MCA}
can be extracted using \code{reducedDim()} function.
}
\description{
Perform a Multiple Correspondence Analysis (MCA) on cells, based on
the expression data in a SingleCellExperiment object. It is modified based on the
\code{RunMCA} of \code{CelliD} with the source codes of C++.
}
\examples{
library(scuttle)
library(SingleCellExperiment)
small.sce <- mockSCE()
small.sce <- logNormCounts(small.sce)
# To improve computational efficiency, you can use RhpcBLASctl to control the number 
# of threads on BLAS. From example
# RhpcBLASctl::blas_set_num_threads(threads = 48)
small.sce <- runMCA(small.sce, assay.type = 'logcounts',
                    reduction.name = 'MCA', ncomponents = 20) 
# The MCA result can be extracted using reducedDim of SingleCellExperiment
mca.res <- reducedDim(small.sce, 'MCA')
mca.res |> str()
}
