% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-lisa.R
\name{runLISA}
\alias{runLISA}
\alias{runLISA,SingleCellExperiment-method}
\alias{runLISA,SingleCellExperiment}
\alias{runLISA,SVPExperiment-method}
\alias{runLISA,SVPExperiment}
\title{Local indicators of spatial association analysis}
\usage{
runLISA(
  data,
  features,
  assay.type = "logcounts",
  sample_id = "all",
  method = c("localG", "localmoran"),
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  reduction.used = NULL,
  group.by = NULL,
  cells = NULL,
  action = c("get", "add", "only"),
  alternative = "two.sided",
  flag.method = c("mean", "median"),
  BPPARAM = SerialParam(),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  ...
)

\S4method{runLISA}{SingleCellExperiment}(
  data,
  features,
  assay.type = "logcounts",
  sample_id = "all",
  method = c("localG", "localmoran"),
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  reduction.used = NULL,
  group.by = NULL,
  cells = NULL,
  action = c("get", "add", "only"),
  alternative = "two.sided",
  flag.method = c("mean", "median"),
  BPPARAM = SerialParam(),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  ...
)

\S4method{runLISA}{SVPExperiment}(
  data,
  features,
  assay.type = "logcounts",
  sample_id = "all",
  method = c("localG", "localmoran"),
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  reduction.used = NULL,
  group.by = NULL,
  cells = NULL,
  action = c("get", "add", "only"),
  alternative = "two.sided",
  flag.method = c("mean", "median"),
  BPPARAM = SerialParam(),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  ...
)
}
\arguments{
\item{data}{a \linkS4class{SingleCellExperiment} object with contains \code{UMAP} or \code{TSNE},
or a \linkS4class{SpatialExperiment} object, or a \linkS4class{SVPExperiment} object with specified
\code{gsvaexp} argument.}

\item{features}{the feature name or index of data object, which are required. If \code{gsvaexp} is
provided and \code{data} is \linkS4class{SingleCellExperiment}, it should be the features from
\code{rownames(gsvaExp(data, gsvaexp))}.}

\item{assay.type}{which expressed data to be pulled to run, default is \code{logcounts}.}

\item{sample_id}{character the sample(s) in the \linkS4class{SpatialExperiment} object whose cells/spots to use.
Can be \code{all} to compute metric for all samples; the metric is computed separately for each sample.
default is \code{"all"}.}

\item{method}{character the method for the local spatial statistic, one of \code{'localG'}, \code{"localmoran"},
default is \code{'localG'}.}

\item{weight}{object, which can be \code{nb}, \code{listw} or \code{Graph} object, default is NULL,
meaning the spatial neighbours weights will be calculated using the \code{weight.method}.
if the \code{data} contains multiple samples, and the \code{sample_id} is specified, it should be
provided as a list object with names (using \code{sample_id}).}

\item{weight.method}{character the method to build the spatial neighbours weights, default
is \code{voronoi} (Voronoi tessellation). Other method, which requires coord matrix as input and returns
\code{nb}, \code{listw} or \code{Graph} object, also is available, such as \code{"knearneigh"},
\code{'dnearneigh'}, \code{"gabrielneigh"}, \code{"relativeneigh"}, which are from \code{spdep} package.
default is \code{knn}, if it is \code{"none"}, meaning the distance weight of each spot is used to
the weight.}

\item{reduction.used}{character used as spatial coordinates to calculate the neighbours weights,
default is \code{NULL}, the result of reduction can be specified, such as \code{UMAP}, \code{TSNE}, \code{PCA}.
If it is specified, the weight neighbours matrix will be calculated using the result of specified reduction.}

\item{group.by}{character a specified category column names (for example the cluster column name) of
\code{colData(data)}. Or a vector of length equal to \code{ncol(x)}, specifying the group to which each cell
is assigned. If it was specified, the adjacency weighted matrix will be built based on the principle that
spots or cells in the same category are adjacent, default is NULL.}

\item{cells}{the cell name or index of data object, default is NULL.}

\item{action}{character, which control the type of return result, default is \code{get}, which will return
a \linkS4class{SimpleList}.}

\item{alternative}{a character string specifying the alternative hypothesis, default is \code{two.sided}.}

\item{flag.method}{a character string specifying the method to calculate the threshold for the cluster
type, default is \code{"mean"}. Other option is \code{"median"}.}

\item{BPPARAM}{A BiocParallelParam object specifying whether perform the analysis in parallel using
\code{BiocParallel} default is \code{SerialParam()}, meaning no parallel.
You can use \code{BiocParallel::MulticoreParam(workers=4, progressbar=TRUE)} to parallel it,
the \code{workers} of \code{MulticoreParam} is the number of cores used, see also
\code{\link[BiocParallel]{MulticoreParam}}. default is \code{SerialParam()}.}

\item{verbose}{logical whether print the help information, default is TRUE.}

\item{gsvaexp}{which gene set variation experiment will be pulled to run, this only work when \code{data} is a
\linkS4class{SVPExperiment}, default is NULL.}

\item{gsvaexp.assay.type}{which assay data in the specified \code{gsvaexp} will be used to run, default is NULL.}

\item{gsvaexp.features}{character which is from the \code{rownames(gsvaExp(data, gsvaexp))}. If \code{gsvaexp} is
specified and \code{data} is \linkS4class{SVPExperiment}, it should be provided. Default is NULL.}

\item{...}{additional parameters the parameters which are from the weight.method function.}
}
\value{
if \code{action = 'get'} (in default), the SimpleList object (like list object) will be return,
if \code{action = 'only'}, the data.frame will be return. if \code{action = 'add'}, the result of LISA is
stored in the \code{localResults} column of \code{int_colData} (internal column metadata), which can be extracted
using \code{\link{LISAResult}}
}
\description{
This function use the local indicators of spatial association (LISA) to identify the hotspot
in the spatial space. In other word, it allow users to explore local variations in spatial
dependence by measuring each area's relative contribution to the corresponding global measure.
}
\examples{
library(SpatialExperiment)
# This example data was extracted from the
# result of runSGSA with gsvaExp() function.
data(hpda_spe_cell_dec)
# using global spatial autocorrelation test to identify the spatial 
# variable features.
svres <- runDetectSVG(hpda_spe_cell_dec, assay.type = 'affi.score', 
           method = 'moransi', action = 'only') 
svres |> dplyr::arrange(rank) |> head()
# In this example, we found the `Cancer clone A` and `Cancer clone B`
# have significant spatial autocorrelation. Next, we use the `runLISA()`
# to explore the spatial hotspots for the features.
lisa.res12 <- hpda_spe_cell_dec |>
   runLISA(
     features = c(1, 2, 3), 
     assay.type = 'affi.score',
     weight.method = "knn",
     k = 10,
     action = 'get',
   )
lisa.res12
lisa.res12[['Acinar cells']] |> head()
lisa.res12[["Cancer clone A"]] |> head()
# add the Gi of LISA result to input object.
hpda_spe_cell_dec <- LISAsce(hpda_spe_cell_dec, lisa.res12)
hpda_spe_cell_dec
gsvaExp(hpda_spe_cell_dec, 'LISA')
# Then using ggsc to visualize the result
#\donttest{
  library(ggplot2)
  library(ggsc)
  p1 <- plot_lisa_feature(hpda_spe_cell_dec, lisa.res12, assay.type=1)
  p2 <- gsvaExp(hpda_spe_cell_dec, 'LISA') |>
  plot_lisa_feature(lisa.res12, assay.type='Gi')
  p1 / p2
#}
}
\references{
\enumerate{
\item Anselin, L. (1995), Local Indicators of Spatial Association—LISA. Geographical Analysis, 27: 93-115.
https://doi.org/10.1111/j.1538-4632.1995.tb00338.x
\item Bivand, R.S., Wong, D.W.S. (2018), Comparing implementations of global and local indicators of spatial association.
TEST 27, 716–748. https://doi.org/10.1007/s11749-018-0599-x
}
}
\seealso{
\code{\link{runDetectSVG}} and \code{\link{runKldSVG}} to identify the spatial variable features.
}
\author{
Shuangbin Xu
}
