% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-plot.R
\name{plot_heatmap_globalbv}
\alias{plot_heatmap_globalbv}
\title{plot_heatmap_globalbv}
\usage{
plot_heatmap_globalbv(
  globalbv,
  moran.t = NULL,
  moran.l = NULL,
  lisa.t = NULL,
  lisa.l = NULL,
  max.point.size = 4.5,
  font.size = 2.5,
  limits.size = NULL,
  limits.colour = NULL,
  dist.method = "euclidean",
  hclust.method = "average",
  threshold = 0.05
)
}
\arguments{
\item{globalbv}{the result of \code{runGLOBALBV} with \code{action = 'get'}.}

\item{moran.t}{the result of global spatial variable features for one type features
default is NULL. or \code{runDetectSVG} and then using \code{svDf} to extract the
result.}

\item{moran.l}{the result of global spatial variable features for another type features
default is NULL.}

\item{lisa.t}{the result of \code{cal_lisa_f1} for another type features.}

\item{lisa.l}{the result of \code{cal_lisa_f1} for one type features}

\item{max.point.size}{the max point size for main dotplot, default is 4.5.}

\item{font.size}{the size of font when the triangle heatmap is displayed, default is 2.5.}

\item{limits.size}{adjust the limit of point size for main dotplot via \code{limits} of
\code{scale_size_continuous}, default is NULL.}

\item{limits.colour}{adjust the limit of point colour for main dotplot via \code{limits} of
\code{scale_fill_gradient2}, default is NULL.}

\item{dist.method}{the distance measure to be used for the result of global bivariate spatial.
which is to measure the dissimilarity between the features, default is \code{'euclidean'}.}

\item{hclust.method}{the agglomeration method to be used for the result of global bivariate spatial.
which is also to measure the similarity between the features, default is \code{'averate'}.}

\item{threshold}{numeric the threshold to display the point with the significance level,
default is 0.05.}
}
\value{
a ggplot2 or aplot object
}
\description{
visualize the result of global bivariate spatial analysis with heatmap
}
\examples{
data(hpda_spe_cell_dec)
gbv.res <- runGLOBALBV(
              hpda_spe_cell_dec, features1=rownames(hpda_spe_cell_dec), 
              assay.type=1, add.pvalue=TRUE, permutation=NULL, alternative='greater'
           )

moran.res <- runDetectSVG(hpda_spe_cell_dec, assay.type=1) |> svDf() 

lisa.res <- runLISA(hpda_spe_cell_dec, features=rownames(hpda_spe_cell_dec), assay.type=1)

lisa.f1 <- cal_lisa_f1(hpda_spe_cell_dec, lisa.res, group.by='cluster_domain') 

plot_heatmap_globalbv(gbv.res, moran.t=moran.res, lisa.t=lisa.f1)
}
