% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_re_genes.R
\name{get_promoters}
\alias{get_promoters}
\title{Extract promoter regions annotated gene symbols from a TxDb and AnnotationDbi object}
\usage{
get_promoters(
  txdb,
  annot_dbi,
  upstream,
  downstream,
  protein_coding_only = TRUE
)
}
\arguments{
\item{txdb}{\code{TxDb} object for genome annotation (required if annotation requested).}

\item{annot_dbi}{\code{AnnotationDbi} object for gene ID mapping (required if annotation requested).}

\item{upstream}{Single integer value indicating the number of bases upstream
from the TSS (transcription start sites) (default \code{"2000kb"}).}

\item{downstream}{Single integer values indicating the number of bases downstream
from the TSS (transcription start sites) (default \code{"2000kb"}).}

\item{protein_coding_only}{Logical; restrict to protein-coding genes (default TRUE).}
}
\value{
A GRanges object with the chromosomes, start and end positions
of defined specie promoter regions together with the official gene symbol
stored in the \code{gene_id} metadata column.
}
\description{
Extract promoter regions annotated gene symbols from a TxDb and AnnotationDbi object
}
