% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_re_genes.R
\name{annotate_with_nearest}
\alias{annotate_with_nearest}
\title{Annotates regulatory elements (e.g., ATAC-seq peaks) to the nearest gene}
\usage{
annotate_with_nearest(
  peaks,
  txdb,
  annot_dbi,
  protein_coding_only = TRUE,
  verbose = TRUE,
  add_tss_annotation = FALSE,
  upstream,
  downstream
)
}
\arguments{
\item{peaks}{A \code{GRanges} or \code{data.frame} of peaks with at least the following columns:
\describe{
\item{seqnames}{Chromosome name of the regulatory region (e.g., \code{"chr1"}). Only for data.frames.}
\item{start}{Start coordinate of the peak. Only for data.frames.}
\item{end}{End coordinate of the peak. Only for data.frames.}
\item{region_id}{Unique identifier of the region (e.g., \code{chr1-5000-5800})}
}}

\item{txdb}{\code{TxDb} object for genome annotation (required if annotation requested).}

\item{annot_dbi}{\code{AnnotationDbi} object for gene ID mapping (required if annotation requested).}

\item{protein_coding_only}{Logical; restrict to protein-coding genes (default TRUE).}

\item{verbose}{Logical; print messages (default TRUE).}

\item{add_tss_annotation}{Logical; annotate regulatory elements overlapping TSS (default FALSE).
If TRUE, use +/- 1bp TSS.}

\item{upstream}{Single integer value indicating the number of bases upstream
from the TSS (transcription start sites) (default \code{"2000kb"}).}

\item{downstream}{Single integer values indicating the number of bases downstream
from the TSS (transcription start sites) (default \code{"2000kb"}).}
}
\value{
A \code{data.frame} of peaks annotated to its nearest gene, with columns:
\item{distanceToTSS}{Distance to the nearest TSS}
\item{gene_id}{Identifier of the gene. Must be an official gene symbol (e.g., \code{GAPDH})}
\item{annotation}{\code{"Promoter"} or \code{"Distal"} based on distance}
}
\description{
based on distance to the transcription start site (TSS), using a \code{TxDb}
reference and gene annotations from \code{org.*.db} packages.
}
\examples{
library(dplyr)
library(TxDb.Hsapiens.UCSC.hg38.knownGene)
library(org.Hs.eg.db)

data(atac)
peaks <- unique(unlist(atac)[, c("region_id")])

annotation_near <- annotate_with_nearest(
  peaks = peaks,
  txdb = TxDb.Hsapiens.UCSC.hg38.knownGene,
  annot_dbi = org.Hs.eg.db,
  protein_coding_only = TRUE,
  verbose = TRUE,
  add_tss_annotation = FALSE,
  upstream = 2000,
  downstream = 2000
)
}
