% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpcaResult-class.R
\name{SetCommonFeatures,tpcaResult-method}
\alias{SetCommonFeatures,tpcaResult-method}
\alias{SetCommonFeatures}
\title{Set CommonFeatures}
\usage{
\S4method{SetCommonFeatures}{tpcaResult}(object, commonFeatures)
}
\arguments{
\item{object}{and object of class tpcaResult}

\item{commonFeatures}{a vector of characters
indicating the common features across replicates}
}
\value{
a vector of common features across
replicates
}
\description{
Set CommonFeatures
}
\examples{
m1 <- matrix(1:12, ncol = 4)
m2 <- matrix(2:13, ncol = 4)
m3 <- matrix(c(2:10, 1:7), ncol = 4)

rownames(m1) <- 1:3
rownames(m2) <- 2:4
rownames(m3) <- 2:5

mat_list <- list(
    m1, m2, m3
)

tpcaObj <- new("tpcaResult", ObjList = mat_list)
SetCommonFeatures(tpcaObj, c("2", "3"))
}
