% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RiboCrypt_app.R
\name{RiboCrypt_app}
\alias{RiboCrypt_app}
\title{Create RiboCrypt app}
\usage{
RiboCrypt_app(
  validate.experiments = TRUE,
  options = list(launch.browser = ifelse(interactive(), TRUE, FALSE)),
  all_exp = list.experiments(validate = validate.experiments),
  browser_options = c(),
  init_tab_focus = "browser",
  metadata = NULL,
  all_exp_meta = all_exp[grep("all_samples-", name), ]
)
}
\arguments{
\item{validate.experiments}{logical, default TRUE, set to FALSE
to allow starting the app with malformed experiments, be careful
will crash if you try to load that experiment!}

\item{options}{list of arguments, default
\code{list("launch.browser" = ifelse(interactive(), TRUE, FALSE))}}

\item{all_exp}{a data.table, default:
\code{list.experiments(validate = validate.experiments)}. Which experiments
do you want to allow your app to see, default is all in your system config
path.}

\item{browser_options}{named character vector of browser specific arguments:\cr
- default_experiment : Which experiment to select, default: first one\cr
- default_gene : Which genes to select, default: first one\cr
- default_isoform : Which isoform to select, default: first one\cr
- default_libs : Which libraries to select: first one, else a single string,
where libs are seperated by ",", like "RFP_WT_r1|RFP_WT_r2". Also support
 run ids (SRR... etc)\cr
- default_kmer : K-mer windowing size, default: 1\cr
- default_frame_type : Ribo-seq line type, default: "lines"\cr
- default_view_mode : "tx", alternative "genomic"
- default_experiment_meta : Which experiment to select for meta analysis,
   default: first one\cr
- default_gene_meta : Which genes to select for meta analysis,
  default: first one\cr
- default_isoform_meta : Which isoform to select for meta analysis,
   default: first one\cr
- translons : Use translon annotation, default "FALSE"\cr
- plot_on_start : Plot when starting, default: "FALSE"\cr
- hide_settings : Hide settings bar in browser on start, default "TRUE"\cr}

\item{init_tab_focus}{character, default "browser". Which tab to open on
init.}

\item{metadata}{a path to csv or a data.table of metadata columns,
must contain a "Run" column to merge IDs to ORFik experiments.
It is used in the metabrowser tab for grouping of samples.}

\item{all_exp_meta}{a data.table, default:
\code{all_exp[grep("all_samples-", name),]}. Can also be NULL, to ignore
the metabrowser completly.
It is the subset of all_exp which are collections (the set of
all experiments per organism), this will be fed to the metabrowser, while
remaining all_exp are used in all other modules.}
}
\value{
RiboCrypt shiny app
}
\description{
Create RiboCrypt app
}
\examples{
run_variable <- 1 # Ignore check test limit
## Default run
# RiboCrypt_app()
## Plot on start
# RiboCrypt_app(browser_options = c(plot_on_start = "TRUE"))
## Init with an experiment and gene (you must of course have the experiment)

#RiboCrypt_app(validate.experiments = FALSE,
#       browser_options = c(plot_on_start = "TRUE",
#                           default_experiment = "all_merged-Homo_sapiens_2024_8",
#                           default_gene = "ATF4-ENSG00000128272"))
#RiboCrypt_app(validate.experiments = FALSE, all_exp = all_exp,
#browser_options = c(plot_on_start = "TRUE",
#                    default_experiment = "human_all_merged_l50",
#                    default_gene = "RPL12-ENSG00000197958",
#                    default_isoform = "ENST00000361436",
#                    default_view_mode = "genomic"))
#RiboCrypt_app(validate.experiments = FALSE,
#       browser_options = c(plot_on_start = "TRUE",
#                           default_experiment = "all_merged-Saccharomyces_cerevisiae",
#                           default_gene = "EFM5-YGR001",
#                           default_view_mode = "genomic"))
}
