% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools_internal.R
\encoding{UTF-8}
\name{validateGDSClass}
\alias{validateGDSClass}
\title{Validate that the input parameter is a GDS object}
\usage{
validateGDSClass(gds, name)
}
\arguments{
\item{gds}{an object of class \link[gdsfmt]{gds.class} (a GDS file), the
1 KG GDS file.}

\item{name}{a \code{character} string that represents the name of the
parameter that is tested.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
This function validates that the input parameter inherits
the \link[gdsfmt]{gds.class} class.
}
\examples{

## Directory where demo GDS files are located
dataDir <- system.file("extdata", package="RAIDS")

## The 1KG GDS file (opened)
gds1KG <- openfn.gds(file.path(dataDir,
                "PopulationReferenceDemo.gds"), readonly=TRUE)

## The validation should be successful
RAIDS:::validateGDSClass(gds=gds1KG, name="gds")

## All GDS file must be closed
closefn.gds(gdsfile=gds1KG)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
