% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateComputeAncestryFromSyntheticFile}
\alias{validateComputeAncestryFromSyntheticFile}
\title{Validate input parameters for computeAncestryFromSyntheticFile()
function}
\usage{
validateComputeAncestryFromSyntheticFile(
  gdsReference,
  gdsProfile,
  listFiles,
  currentProfile,
  spRef,
  studyIDSyn,
  np,
  listCatPop,
  fieldPopIn1KG,
  fieldPopInfAnc,
  kList,
  pcaList,
  algorithm,
  eigenCount,
  missingRate,
  verbose
)
}
\arguments{
\item{gdsReference}{an object of class \link[gdsfmt]{gds.class} (a GDS
file), the opened Population Reference GDS file.}

\item{gdsProfile}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the opened Profile GDS file.}

\item{listFiles}{a \code{vector} of \code{character} strings representing
the name of files that contain the results of ancestry inference done on
the synthetic profiles for multiple values of \emph{D} and \emph{K}. The files must
exist.}

\item{currentProfile}{a \code{character} string representing the profile
identifier of the current profile on which ancestry will be inferred.}

\item{spRef}{a \code{vector} of \code{character} strings representing the
known super population ancestry for the 1KG profiles. The Population
Reference profile
identifiers are used as names for the \code{vector}.}

\item{studyIDSyn}{a \code{character} string corresponding to the study
identifier. The study identifier must be present in the GDS Sample file.}

\item{np}{a single positive \code{integer} representing the number of
threads.}

\item{listCatPop}{a \code{vector} of \code{character} string
representing the list of possible ancestry assignations.}

\item{fieldPopIn1KG}{a \code{character} string representing the name of the
column that contains the known ancestry for the reference profiles in
the Reference GDS file.}

\item{fieldPopInfAnc}{a \code{character} string representing the name of
the column that will contain the inferred ancestry for the specified
dataset. Default: \code{"SuperPop"}.}

\item{kList}{a \code{vector} of \code{integer} representing  the list of
values tested for the  \emph{K} parameter. The \emph{K} parameter represents the
number of neighbors used in the K-nearest neighbor analysis.}

\item{pcaList}{a \code{vector} of \code{integer} representing  the list of
values tested for the  \emph{D} parameter. The \emph{D} parameter represents the
number of dimensions used in the PCA analysis.}

\item{algorithm}{a \code{character} string representing the algorithm used
to calculate the PCA.}

\item{eigenCount}{a single \code{integer} indicating the number of
eigenvectors that will be in the output of the \link[SNPRelate]{snpgdsPCA}
function; if 'eigenCount' <= 0, then all eigenvectors are returned.}

\item{missingRate}{a \code{numeric} value representing the threshold
missing rate at with the SNVs are discarded; the SNVs are retained in the
\link[SNPRelate]{snpgdsPCA}
with "<= missingRate" only; if \code{NaN}, no missing threshold.}

\item{verbose}{a \code{logical} indicating if messages should be printed
to show how the different steps in the function.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
This function validates the input parameters for the
\code{\link{computeAncestryFromSyntheticFile}} function.
}
\examples{

## Required library
library(gdsfmt)

## Directory where demo GDS files are located
dataDir <- system.file("extdata", package="RAIDS")

## The 1KG Population Reference GDS demo file (opened)
gds1KG <- openfn.gds(file.path(dataDir,
            "PopulationReferenceDemo.gds"), readonly=TRUE)

## The Profile GDS (opened)
gdsSample <- openfn.gds(file.path(dataDir,
                    "GDS_Sample_with_study_demo.gds"), readonly=TRUE)

listFiles <- file.path(dataDir,  "listSNPIndexes_Demo.rds")

## The validation should be successful
RAIDS:::validateComputeAncestryFromSyntheticFile(gdsReference=gds1KG,
    gdsProfile=gdsSample, listFiles=listFiles, currentProfile="sample01",
    spRef=c("EUR", "AFR"), studyIDSyn="Synthetic", np=1L,
    listCatPop=c("EAS", "EUR", "AFR", "AMR", "SAS"),
    fieldPopIn1KG="superpop", fieldPopInfAnc="Superpop", kList=c(2, 3, 4),
    pcaList=c(3, 4, 5), algorithm="exact", eigenCount=32L, missingRate=0.2,
    verbose=FALSE)

## All GDS file must be closed
closefn.gds(gdsfile=gds1KG)
closefn.gds(gdsfile=gdsSample)

}
\references{
Galinsky KJ, Bhatia G, Loh PR, Georgiev S, Mukherjee S, Patterson NJ,
Price AL. Fast Principal-Component Analysis Reveals Convergent Evolution
of ADH1B in Europe and East Asia. Am J Hum Genet. 2016 Mar 3;98(3):456-72.
doi: 10.1016/j.ajhg.2015.12.022. Epub 2016 Feb 25.
}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
