% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools_internal.R
\encoding{UTF-8}
\name{extractNucleotide}
\alias{extractNucleotide}
\title{Filtering the read counts for a specific nucleotide}
\usage{
extractNucleotide(nucleotide, count, curNucleo)
}
\arguments{
\item{nucleotide}{a \code{vector} of  a \code{character} strings
representing the nucleotides (ex: A, C, G or T).}

\item{count}{a \code{vector} of \code{numeric} representing the counts for
each nucleotide listed in \code{nucleotide} parameter.}

\item{curNucleo}{a \code{character} strings representing the nucleotide
that will be retained (ex: A, C, G or T).}
}
\value{
a \code{numeric} representing the counts for the selected
nucleotide. The default value is \code{0}.
}
\description{
The function returns the read counts for the specific
nucleotide or zero when read counts are not available.
}
\examples{

## Nucleotides vector
nuc <- c("A", "G", "C", "T")

## Count vector
cnt <- c(100, 200, 4, 32)

## Return the count for the nucleotide "G"
RAIDS:::extractNucleotide(nucleotide=nuc, count=cnt, curNucleo="G")

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
