% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetic.R
\encoding{UTF-8}
\name{computeSyntheticROC}
\alias{computeSyntheticROC}
\title{Calculate the AUROC of the inferences for specific
values of D and K using the inferred ancestry results from the synthetic
profiles.}
\usage{
computeSyntheticROC(
  matKNN,
  matKNNAncestryColumn,
  pedCall,
  pedCallAncestryColumn,
  listCall = c("EAS", "EUR", "AFR", "AMR", "SAS")
)
}
\arguments{
\item{matKNN}{a \code{data.frame} containing the inferred ancestry results
for fixed values of \emph{D} and \emph{K}. On of the column names of the
\code{data.frame} must correspond to the \code{matKNNAncestryColumn}
argument.}

\item{matKNNAncestryColumn}{a \code{character} string
representing the
name of the column that contains the inferred ancestry for the specified
synthetic profiles. The column must be present in the \code{matKNN}
argument.}

\item{pedCall}{a \code{data.frame} containing the information about
the super-population information from the 1KG GDS file
for profiles used to generate the synthetic profiles. The \code{data.frame}
must contained a column named as the \code{pedCallAncestryColumn} argument.
The row names must correspond to the sample identifiers (mandatory).}

\item{pedCallAncestryColumn}{a \code{character} string representing the
name of the column that contains the known ancestry for the reference
profiles in the Reference GDS file. The column must be present in
the \code{pedCall} argument.}

\item{listCall}{a \code{vector} of \code{character} strings representing
the list of all possible ancestry assignations.
Default: \code{c("EAS", "EUR", "AFR", "AMR", "SAS")}.}
}
\value{
\code{list} containing 3 entries:
\describe{
\item{\code{matAUROC.All}}{ a \code{data.frame} containing the AUROC for all
the ancestry results.  }
\item{\code{matAUROC.Call}}{ a \code{data.frame} containing the AUROC
information for each super-population.}
\item{\code{listROC.Call}}{ a \code{list} containing the output from the
\code{roc} function for each super-population.}
}
}
\description{
The function calculates the AUROC of the inferences for specific
values of D and K using the inferred ancestry results from the synthetic
profiles. The calculations are done on each super-population separately as
well as on all the results together.
}
\examples{

## Loading demo dataset containing pedigree information for synthetic
## profiles and known ancestry of the profiles used to generate the
## synthetic profiles
data(pedSynthetic)

## Loading demo dataset containing the inferred ancestry results
## for the synthetic data
data(matKNNSynthetic)

## The inferred ancestry results for the synthetic data using
## values of D=6 and K=5
matKNN <- matKNNSynthetic[matKNNSynthetic$K == 6 & matKNNSynthetic$D == 5, ]

## Compile statistics from the
## synthetic profiles for fixed values of D and K
results <- RAIDS:::computeSyntheticROC(matKNN=matKNN,
    matKNNAncestryColumn="SuperPop",
    pedCall=pedSynthetic, pedCallAncestryColumn="superPop",
    listCall=c("EAS", "EUR", "AFR", "AMR", "SAS"))

results$matAUROC.All
results$matAUROC.Call
results$listROC.Call

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
