% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{addGDSStudyPruning}
\alias{addGDSStudyPruning}
\title{Add the pruned.study entry related to the SNV dataset in the
Profile GDS file}
\usage{
addGDSStudyPruning(gdsProfile, pruned)
}
\arguments{
\item{gdsProfile}{an object of class \link[gdsfmt]{gds.class} (a GDS file),
the opened Profile GDS file.}

\item{pruned}{a \code{vector} of \code{character} string representing the
name of the SNVs.}
}
\value{
The integer \code{0L} when successful.
}
\description{
This function adds the names of the SNVs into the node called
"pruned.study" in GDS
Sample file. If a "pruned.study" entry is already present, the entry is
deleted and a new entry is created.
}
\examples{

## Required library
library(gdsfmt)

## Create a temporary GDS file in an test directory
gdsFilePath <- file.path(tempdir(), "GDS_TEMP_1.gds")

## Create and open the GDS file
tmpGDS  <- createfn.gds(filename=gdsFilePath)

## Vector of low allelic fraction
study <- c("s19222", 's19588', 's19988', 's20588', 's23598')

## Add segments to the GDS file
RAIDS:::addGDSStudyPruning(gdsProfile=tmpGDS, pruned=study)

## Read lap information from GDS file
read.gdsn(index.gdsn(node=tmpGDS, path="pruned.study"))

## Close GDS file
closefn.gds(gdsfile=tmpGDS)

## Delete the temporary GDS file
unlink(x=gdsFilePath, force=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
