% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umapClustering.R
\name{groupLabelDimRedData}
\alias{groupLabelDimRedData}
\title{Reduce the number of labels for DIM reduction plot based on the
gene/taxon frequency}
\usage{
groupLabelDimRedData(data4dimRed = NULL, freqCutoff = c(0,200))
}
\arguments{
\item{data4dimRed}{data for dimension reduction (from prepareDimRedData)}

\item{freqCutoff}{gene/taxon frequency cutoff range. Any labels that are
outside of this range will be assigned as [Other]}
}
\value{
A dataframe similar to input data4dimRed, but with modified Label
column, where less frequent labels are grouped together as "Other"
}
\description{
Reduce the number of labels for DIM reduction plot based on the
gene/taxon frequency
}
\examples{
rawInput <- system.file(
   "extdata", "test.main.long", package = "PhyloProfile", mustWork = TRUE
)
longDf <- createLongMatrix(rawInput)
data4dimRed <- prepareDimRedData(longDf, "phylum")
groupLabelDimRedData(data4dimRed, freqCutoff = c(3,5))
}
\seealso{
\code{\link{prepareDimRedData}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
