% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_vcf.R
\name{index_vcf}
\alias{index_vcf}
\title{Tabix-index file: VCF}
\source{
Borrowed function from
\href{https://github.com/RajLabMSSM/echotabix/blob/main/R/convert.R}{
echotabix}.
}
\usage{
index_vcf(path, verbose = TRUE)
}
\arguments{
\item{path}{Path to VCF.}

\item{verbose}{Print messages.}
}
\value{
Path to tabix-indexed tabular file
}
\description{
Convert summary stats file to tabix format
}
\examples{
eduAttainOkbayPth <- system.file("extdata", "eduAttainOkbay.txt",
                                 package = "MungeSumstats")
sumstats_dt <- data.table::fread(eduAttainOkbayPth, nThread = 1)
sumstats_dt <- 
MungeSumstats:::standardise_sumstats_column_headers_crossplatform(
    sumstats_dt = sumstats_dt)$sumstats_dt
sumstats_dt <- MungeSumstats:::sort_coords(sumstats_dt = sumstats_dt)
path <- tempfile(fileext = ".tsv")
MungeSumstats::write_sumstats(sumstats_dt = sumstats_dt, save_path = path)
    
indexed_file <- MungeSumstats::index_tabular(path = path)
}
\seealso{
Other tabix: 
\code{\link{index_tabular}()}
}
\concept{tabix}
\keyword{internal}
