% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{mp_plot_rarecurve}
\alias{mp_plot_rarecurve}
\alias{mp_plot_rarecurve,MPSE-method}
\alias{mp_plot_rarecurve,MPSE}
\alias{mp_plot_rarecurve,tbl_mpse-method}
\alias{mp_plot_rarecurve,tbl_mpse}
\alias{mp_plot_rarecurve,grouped_df_mpse-method}
\alias{mp_plot_rarecurve,grouped_tbl_mpse}
\title{Rarefaction alpha index with MPSE}
\usage{
mp_plot_rarecurve(
  .data,
  .rare,
  .alpha = c("Observe", "Chao1", "ACE"),
  .group = NULL,
  nrow = 1,
  plot.group = FALSE,
  ...
)

\S4method{mp_plot_rarecurve}{MPSE}(
  .data,
  .rare,
  .alpha = c("Observe", "Chao1", "ACE"),
  .group = NULL,
  nrow = 1,
  plot.group = FALSE,
  ...
)

\S4method{mp_plot_rarecurve}{tbl_mpse}(
  .data,
  .rare,
  .alpha = c("Observe", "Chao1", "ACE"),
  .group = NULL,
  nrow = 1,
  plot.group = FALSE,
  ...
)

\S4method{mp_plot_rarecurve}{grouped_df_mpse}(
  .data,
  .rare,
  .alpha = c("Observe", "Chao1", "ACE"),
  .group = NULL,
  nrow = 1,
  plot.group = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE object or tbl_mpse after it was performed \code{mp_cal_rarecurve} with \code{action='add'}}

\item{.rare}{the column names of}

\item{.alpha}{the names of alpha index, which should be one or more of Observe, 
ACE, Chao1, default is Observe.}

\item{.group}{the column names of group, default is NULL, when it is provided, the
rarecurve lines will group and color with the \code{group}.}

\item{nrow}{integer Number of rows in \code{\link[ggplot2]{facet_wrap}}.}

\item{plot.group}{logical whether to combine the samples, default is FALSE,
when it is TRUE, the samples of same group will be represented by their group.}

\item{...}{additional parameters, see also \code{\link[ggplot2]{geom_smooth}}.}
}
\description{
Rarefaction alpha index with MPSE
}
\examples{
\dontrun{
data(mouse.time.mpse)
mpse <- mouse.time.mpse \%>\%
        mp_rrarefy()
mpse
mpse \%<>\% mp_cal_rarecurve(.abundance=RareAbundance, chunks=100, action="add") 
mpse
p1 <- mpse \%>\% mp_plot_rarecurve(.rare=RareAbundanceRarecurve, .alpha="Observe")
p2 <- mpse \%>\% mp_plot_rarecurve(.rare=RareAbundanceRarecurve, .alpha="Observe", .group=time)
p3 <- mpse \%>\% mp_plot_rarecurve(.rare=RareAbundanceRarecurve, .alpha="Observe", .group=time, plot.group=TRUE)
}
}
\author{
Shuangbin Xu
}
