% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-io.R
\name{mp_import_metaphlan}
\alias{mp_import_metaphlan}
\title{Import function to load the output of MetaPhlAn.}
\usage{
mp_import_metaphlan(
  profile,
  mapfilename = NULL,
  treefile = NULL,
  linenum = NULL,
  ...
)
}
\arguments{
\item{profile}{the output file (text format) of MetaPhlAn.}

\item{mapfilename}{the sample information file or data.frame,
default is NULL.}

\item{treefile}{the path of MetaPhlAn tree file (
mpa_v30_CHOCOPhlAn_201901_species_tree.nwk), default is NULL.}

\item{linenum}{a integer, sometimes the output file of MetaPhlAn ( < 3)
contained the sample information in the first several lines.
The linenum should be required.
for example:
\preformatted{
group A A A A B B B B
subgroup A1 A1 A2 A2 B1 B1 B2 B2
subject S1 S2 S3 S4 S5 S6 S7 S8
Bacteria 99 99 99 99 99 99 99 99
...
}
the \code{linenum} should be set to 3.
\preformatted{
sampleid A1 A2 A3 A4 A5
Bacteria 99 99 99 99 99
...
}
The \code{linenum} should be set to 1.}

\item{...}{additional parameters, meaningless now.}
}
\description{
Import function to load the output of MetaPhlAn.
}
\details{
When the output abundance of MetaPhlAn is relative abundance, the \code{force} of \code{mp_cal_abundance}
should be set to TRUE, and the \code{relative} of \code{mp_cal_abundance} should be set to FALSE.
Because the abundance profile will be rarefied in the default (force=FALSE), which requires the integer (count) 
abundance, then the relative abundance will be calculated in the default (relative=TRUE).
}
\examples{
file1 <- system.file("extdata/MetaPhlAn", "metaphlan_test.txt", package="MicrobiotaProcess")
sample.file <- system.file("extdata/MetaPhlAn", "sample_test.txt", package="MicrobiotaProcess")
readLines(file1, n=3) \%>\% writeLines()
mpse1 <- mp_import_metaphlan(profile=file1, mapfilename=sample.file)
mpse1
}
\author{
Shuangbin Xu
}
