% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff-ml-utilities.R
\name{split_data}
\alias{split_data}
\title{Split Large Vector or DataFrame}
\usage{
split_data(x, nums, chunks = NULL, random = FALSE)
}
\arguments{
\item{x}{vector class or data.frame class.}

\item{nums}{integer.}

\item{chunks}{integer. use chunks if nums is missing.
Note nums and chunks shouldn't concurrently be NULL, 
default is NULL.}

\item{random}{bool, whether split randomly, default is FALSE,
if you want to split data randomly, you can set TRUE, and
if you want the results are reproducible, you should add 
seed before.}
}
\value{
the subset of x, vector or data.frame class.
}
\description{
Split large vector or dataframe to list class, which contian subset vectors
or dataframe of origin vector or dataframe.
}
\examples{
data(iris)
irislist <- split_data(iris, 40)
dalist <- c(1:100)
dalist <- split_data(dalist, 30)
}
\author{
Shuangbin Xu
}
