% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_standards.R
\name{createStandardMixes}
\alias{createStandardMixes}
\title{Create Standard Mixes from a Matrix of Standard Compounds}
\usage{
createStandardMixes(
  x,
  max_nstd = 10,
  min_nstd = 5,
  min_diff = 2,
  iterativeRandomization = FALSE
)
}
\arguments{
\item{x}{\code{numeric} matrix with row names representing the compounds and
columns representing different adducts. Such a matrix with m/z values for
different adducts for compounds could e.g. be created with the
\code{\link[MetaboCoreUtils:mass2mz]{MetaboCoreUtils::mass2mz()}} function.}

\item{max_nstd}{\code{numeric} number of maximum standards per group.}

\item{min_nstd}{\code{numeric} number of minimum standards per group. Only
needed when using \code{iterativeRandomization = TRUE}.}

\item{min_diff}{\code{numeric} Minimum difference for considering two values as
distinct.}

\item{iterativeRandomization}{\code{logical} default \code{FALSE}. If set to \code{TRUE},
\code{createStandardMixes} will randomly rearrange the rows of \code{x} until the user
inputs are satisfied.}
}
\value{
\code{data.frame} created by adding a column \code{group} to the input \code{x}
matrix, comprising the group number for each compound.
}
\description{
The \code{createStandardMixes} function defines groups (mixes) of compounds
(standards) with dissimilar m/z values. The expected size of the groups can
be defined with parameters \code{max_nstd} and \code{min_nstd} and the minimum required
difference between m/z values within each group with parameter \code{min_diff}.
The group assignment will be reported in an additional column in the result
data frame.
}
\details{
Users should be aware that because the function iterates through \code{x}, the
compounds at the bottom of the matrix are more complicated to group, and
there is a possibility that some compounds will not be grouped with others.
We advise specifyiong \code{iterativeRandomization = TRUE} even if it takes more
time.
}
\examples{

## Iterative grouping only
x <- matrix(c(135.0288, 157.0107, 184.0604, 206.0424, 265.1118, 287.0937,
              169.0356, 191.0176, 468.9809, 490.9628, 178.0532, 200.0352),
            ncol = 2, byrow = TRUE,
            dimnames = list(c("Malic Acid", "Pyridoxic Acid", "Thiamine",
                                "Uric acid", "dUTP", "N-Formyl-L-methionine"),
                             c("adduct_1", "adduct_2")))
result <- createStandardMixes(x, max_nstd = 3, min_diff = 2)

## Randomize grouping
set.seed(123)
x <- matrix(c(349.0544, 371.0363, 325.0431, 347.0251, 581.0416, 603.0235,
              167.0564, 189.0383, 150.0583, 172.0403, 171.0053, 192.9872,
              130.0863, 152.0682, 768.1225, 790.1044),
            ncol = 2, byrow = TRUE,
            dimnames = list(c("IMP", "UMP", "UDP-glucuronate",
                                "1-Methylxanthine", "Methionine",
                                "Dihydroxyacetone phosphate",
                                "Pipecolic acid", "CoA"),
                             c("[M+H]+", "[M+Na]+")))
result <- createStandardMixes(x, max_nstd = 4, min_nstd = 3, min_diff = 2,
                               iterativeRandomization = TRUE)

}
\author{
Philippine Louail
}
