% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExperimentalDesignSimulation.R
\name{futureExperimentSimulation}
\alias{futureExperimentSimulation}
\title{Test future experimental design using simulated data with user-defined or default templates}
\usage{
futureExperimentSimulation(
  N_proteins = 300,
  N_rep = 3,
  N_Control_Rep = NULL,
  Concentrations = c(0, 1, 3, 10, 30, 100, 300, 1000, 3000),
  IC50_Prediction = FALSE,
  data = NULL,
  strong_proteins = NULL,
  weak_proteins = NULL,
  no_interaction_proteins = NULL,
  drug_name = NULL
)
}
\arguments{
\item{N_proteins}{Number of proteins to simulate. Default = 300.}

\item{N_rep}{Number of replicates for each drug concentration. Default = 3.}

\item{N_Control_Rep}{Number of control replicates. If NULL, uses N_rep.}

\item{Concentrations}{Numeric vector of drug concentrations (in nM scale).
Default = c(0, 1, 3, 10, 30, 100, 300, 1000, 3000).}

\item{IC50_Prediction}{Logical. If TRUE, perform IC50 prediction. Default = FALSE.}

\item{data}{Optional. User's prepared dose-response data (e.g., from MSstatsPrepareDoseResponseFit).
If provided, will extract templates from this data instead of using defaults.}

\item{strong_proteins}{Character vector of protein IDs to use as strong interaction templates.
Only used if data is provided.}

\item{weak_proteins}{Character vector of protein IDs to use as weak interaction templates.
Only used if data is provided.}

\item{no_interaction_proteins}{Character vector of protein IDs to use as no interaction templates.
Only used if data is provided.}

\item{drug_name}{Character. Name of drug to extract templates for. Default = first non-DMSO drug in data.}
}
\value{
A list containing simulated data, MSstats formatted data, dose-response
fit results, hit rate plots, and optionally IC50 predictions.
}
\description{
Test future experimental design using simulated data with user-defined or default templates
}
\examples{
# Example 1: Quick simulation with default templates (small scale for speed)
sim_results <- futureExperimentSimulation(
  N_proteins = 50,  # Small number for quick example
  N_rep = 2,
  N_Control_Rep = 3,
  Concentrations = c(0, 10, 100, 1000),  # Fewer doses for speed
  IC50_Prediction = FALSE
)

# View hit rates
print(sim_results$Hit_Rates_Data)

# Check simulation results
print(paste("Simulated", nrow(sim_results$Simulated_Data), "data points"))

\dontrun{
# Example 2: Full simulation with standard parameters
full_sim <- futureExperimentSimulation(
  N_proteins = 3000,
  N_rep = 3,
  N_Control_Rep = 6,
  Concentrations = c(0, 1, 3, 10, 30, 100, 300, 1000, 3000),
  IC50_Prediction = TRUE
)

# Display power analysis plot
print(full_sim$Hit_Rates_Plot)

# Example 3: Using custom templates from your own data
# Load and prepare your data
data_path <- system.file("extdata", "DIA_MSstats_Normalized.RDS",
                         package = "MSstatsResponse")
dia_data <- readRDS(data_path)

dose_info <- convertGroupToNumericDose(dia_data$ProteinLevelData$GROUP)
dia_data$ProteinLevelData$dose <- dose_info$dose_nM * 1e-9
dia_data$ProteinLevelData$drug <- dose_info$drug

prepared_data <- MSstatsPrepareDoseResponseFit(
  dia_data$ProteinLevelData,
  dose_column = "dose",
  drug_column = "drug",
  protein_column = "Protein",
  log_abundance_column = "LogIntensities"
)

# Run simulation with custom templates
custom_sim <- futureExperimentSimulation(
  N_proteins = 1000,
  N_rep = 3,
  data = prepared_data,
  strong_proteins = c("PROTEIN_A"),
  weak_proteins = c("PROTEIN_B"),
  no_interaction_proteins = c("PROTEIN_C"),
  drug_name = "Drug1",
  Concentrations = c(0, 1, 10, 100, 1000, 3000)
)
}

}
