% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{MSstatsLiP_data}
\alias{MSstatsLiP_data}
\title{MSstatsLiP_data}
\format{
A data.table consisting of 546 rows and 29 columns. Raw TrP data for use in testing
and examples.
}
\usage{
MSstatsLiP_data
}
\description{
Example output of MSstatsLiP converter functions.
}
\details{
Example output of MSstatsLiP converter functions. (Eg. SpectronauttoMSstatsLiPFormat).
A list containing two data.tables named LiP and TrP corresponding to the processed
LiP and TrP data now in MSstatsLiP format. The data.tables contain the following
columns:

\itemize{
\item ProteinName : Character column of protein names
\item PeptideSequence : Character column of peptide sequence name
\item PrecursorCharge : Numeric charge feature
\item FragmentIon : Character fragment ion feature
\item ProductCharge : Numeric charge of product
\item IsotopeLabelType : Character label type
\item Condition : Character label for condition (Eg. Disease/Control)
\item BioReplicate : Name of biological replicate
\item Run : Name of run
\item Fraction : Fraction number if fractionation is present
\item Intensity : Unnormalized feature intensity
\item FULL_PEPTIDE(LiP data only) : Combined protein name and peptide sequence.
Used for LiP data only because LiP is summarized to peptide level (not protein)
}
}
\examples{
head(MSstatsLiP_data$LiP)
head(MSstatsLiP_data$TrP)

}
\keyword{datasets}
