% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIANNtoMSstatsLiPFormat.R
\name{DIANNtoMSstatsLiPFormat}
\alias{DIANNtoMSstatsLiPFormat}
\title{Converts raw LiP MS data from DIA-NN into the format needed for
MSstatsLiP.}
\usage{
DIANNtoMSstatsLiPFormat(
  lip_data,
  trp_data = NULL,
  annotation = NULL,
  global_qvalue_cutoff = 0.01,
  qvalue_cutoff = 0.01,
  pg_qvalue_cutoff = 0.01,
  useUniquePeptide = TRUE,
  removeFewMeasurements = TRUE,
  removeOxidationMpeptides = FALSE,
  removeProtein_with1Feature = FALSE,
  use_log_file = FALSE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL
)
}
\arguments{
\item{lip_data}{name of LiP Skyline output, which is long-format.}

\item{trp_data}{name of TrP Skyline output, which is long-format.}

\item{annotation}{name of 'annotation.txt' data which includes Condition,
BioReplicate, Run. If annotation is already complete in Skyline, use
annotation=NULL (default). It will use the annotation information from input.}

\item{global_qvalue_cutoff}{The global qvalue cutoff. Default is 0.01.}

\item{qvalue_cutoff}{Cutoff for DetectionQValue. Default is 0.01.}

\item{pg_qvalue_cutoff}{local qvalue cutoff for protein groups Run should be
the same as filename. Default is .01.}

\item{useUniquePeptide}{TRUE (default) removes peptides that are assigned
for more than one proteins. We assume to use unique peptide for each protein.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that
have 1 or 2 measurements across runs.}

\item{removeOxidationMpeptides}{TRUE will remove the peptides including
'oxidation (M)' in modification. FALSE is default.}

\item{removeProtein_with1Feature}{TRUE will remove the proteins which have
only 1 feature, which is the combination of peptide, precursor charge,
fragment and charge. FALSE is default.}

\item{use_log_file}{logical. If TRUE, information about data processing will
be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be
saved to a file.}

\item{verbose}{logical. If TRUE, information about data processing wil be
printed to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved. If not provided, such a file will be created
automatically. If 'append = TRUE', has to be a valid path to a file.}
}
\value{
a \code{list} of two data.frames in \code{MSstatsLiP} format
}
\description{
Takes as as input both raw LiP and Trp outputs from DIA-NN
}
\examples{

## Output will be in format
head(MSstatsLiP_data[["LiP"]])
head(MSstatsLiP_data[["TrP"]])
}
