% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppInp.R
\name{ppPermInp}
\alias{ppPermInp}
\title{Permute input genomic state data between genes in the same sample}
\usage{
ppPermInp(real_se, n_perms=100, threads=1)
}
\arguments{
\item{real_se}{A SummarizedExperiment object of CN and RNA states from
real samples with rows as genes and columns as samples.
It is the output from \code{ppRealInp()}.}

\item{n_perms}{Number of permutations. Default: 100}

\item{threads}{Number of threads to run in parallel. Default: 1}
}
\value{
A list of SummarizedExperiment objects of permuted CN and RNA
states. The metadata \code{i} in each obbect denotes its permutation
index.
}
\description{
Permute input genomic state data between genes in the same sample
}
\examples{

freal = system.file('extdata/TcgaInp/inp_real.rds', package='MPAC')
real_se = readRDS(freal)

ppPermInp(real_se, n_perms=3)

}
