% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{integratedPathways}
\alias{integratedPathways}
\title{Access the results of integrative miRNA-mRNA pathway analyses}
\usage{
integratedPathways(object)
}
\arguments{
\item{object}{An object of class
\code{\link[=IntegrativePathwayAnalysis-class]{IntegrativePathwayAnalysis}} containing
the results of a miRNA-mRNA pathway analysis}
}
\value{
A \code{data.frame} object containing the results of the topological analysis,
as returned by the \code{\link[=topologicalAnalysis]{topologicalAnalysis()}} function.
}
\description{
This function accesses the \code{data} slot of a
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} object and returns
a \code{data.frame} with the results of an integrative topological analysis
carried out through the \code{\link[=topologicalAnalysis]{topologicalAnalysis()}} function.
}
\examples{
# load the example IntegrativePathwayAnalysis object
obj <- loadExamples("IntegrativePathwayAnalysis")

# extract results
taipaRes <- integratedPathways(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
