% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{enrichmentMetric}
\alias{enrichmentMetric}
\title{Extract the GSEA ranking metric used for functional enrichment analyses}
\usage{
enrichmentMetric(object)
}
\arguments{
\item{object}{An object of class
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} containing
enrichment results}
}
\value{
A \code{numeric} vector containing the ranking metric.
}
\description{
This function accesses the \code{statistic} slot of a
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} object and returns
a \code{numeric} vector with the metric used to rank genes in GSEA.
}
\examples{
# load example FunctionalEnrichment object
obj <- loadExamples("FunctionalEnrichment")

# extract the ranking metric
rmet <- enrichmentMetric(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
