% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NIMEB.R
\name{NIMEB}
\alias{NIMEB}
\title{Detect differential expression genes for RNA-seq data}
\usage{
NIMEB(countsTable, train_id, gamma, nu = 0.01, reject_rate = 0.1,
ds = FALSE)
}
\arguments{
\item{countsTable}{Matrix or data.frame of short read counts for each genes
in the same or different species.}

\item{train_id}{A vector shows the position of housekeeping genes or
conserved genes in countsTable.}

\item{gamma}{A parameter needed for all kernels except linear.}

\item{nu}{parameter needed for one-classification.}

\item{reject_rate}{A value used in controling the scale of ball, default is
0.01.}

\item{ds}{A value to show the data is for the same species or different
species. If ds is FALSE, the data is the same species, else the data is the
different species.}
}
\value{
list(.) A list of results, "model" represents the model of NIMEB,
which could be used to discriminate a new gene, "gamma" represents the
selected gamma parameters in model NIMEB, "train_error" represents the
corresponding train_error when the value of gamma changed.
}
\description{
Use a normalization-invariant minimum enclosing ball (NIMEB) 
method to discriminate differential expression (DE) genes in the same or 
different species.
}
\examples{
## Simulation data for the same species.
library(SummarizedExperiment)
data(sim_data_sp)
gamma <- seq(1e-06,5e-05,1e-06)
sim_model_sp <- NIMEB(countsTable = assay(sim_data_sp), 
train_id=seq_len(1000), gamma, nu = 0.01, reject_rate = 0.05, ds = FALSE)

## Real data for the same species.
data(real_data_sp)
gamma <- seq(1e-06,5e-05,1e-06)
real_model_sp <- NIMEB(countsTable = assay(real_data_sp), 
train_id=seq_len(530), gamma, nu = 0.01, reject_rate = 0.1, ds = FALSE)

## Simulation data for the different species.
data(sim_data_dsp)
gamma <- seq(1e-07,2e-05,1e-06)
sim_model_dsp <- NIMEB(countsTable = assay(sim_data_dsp), 
train_id=seq_len(1000), gamma, nu = 0.01, reject_rate = 0.1, ds = TRUE)

## Real data for the different species.
data(real_data_dsp)
gamma <- seq(5e-08,5e-07,1e-08)
real_model_dsp <- NIMEB(countsTable = assay(real_data_dsp), 
train_id=seq_len(143), gamma, nu = 0.01, reject_rate = 0.1, ds = TRUE)
}
