% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{datasets}
\alias{datasets}
\alias{datasets_default_columns}
\alias{dataset_detail}
\alias{dataset_derived}
\alias{dataset_metadata}
\alias{dataset_contributors}
\title{HuBMAP Datasets}
\usage{
datasets()

datasets_default_columns(as = c("tibble", "character"))

dataset_detail(uuid)

dataset_derived(uuid)

dataset_metadata(uuid)

dataset_contributors(uuid)
}
\arguments{
\item{as}{character(1) return format. One of \code{"tibble"} (default),
or \code{"character"}.}

\item{uuid}{character(1) corresponding to the HuBMAP Donor UUID
string. This is expected to be a 32-digit hex number.}
}
\value{
\verb{*_columns()} returns a named list \code{name}
containing the column name used in the tibble returned by
\code{samples()}, \code{datasets()},  \code{donors()},
\code{collections()},  or \code{publications()}.
When \code{as = "tibble"},the return value is a tibble
with paths as elements and abbreviations as names.
}
\description{
\code{datasets} returns the details available datasets, ordered by
last modified dates

\verb{*_columns()} returns a tibble or named
character vector describing the content of the tibble returned
by \code{samples()}, \code{datasets()},  \code{donors()}, \code{collections()},
or \code{publications()}.

\code{dataset_detail()} takes a unique dataset_id and
returns details about one specified dataset as a tibble

\code{dataset_derived()} takes a unique sample_id and
returns the derived (support) dataset details. Support datasets normally
belong to Image Pyramid, with image files available to download via
Globus Collection. See details to download in \code{files_globus_url()}.

\code{dataset_metadata()} takes a unique dataset_id and
returns the metadata of the dataset.

\code{dataset_contributors()} takes a unique dataset_id and
returns the contributors of the dataset. For questions for this
dataset, reach out to the individuals listed as contacts, either via
the email address listed in the table or contact information provided
on their ORCID profile page.
}
\details{
Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis

Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis

Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis

Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis
}
\examples{
datasets()
datasets_default_columns()

uuid <- "7754aa5ebde628b5e92705e33e74a4ef"
dataset_detail(uuid)
# no derived dataset
uuid <- "3acdb3ed962b2087fbe325514b098101"
dataset_derived(uuid)

# with derived dataset
uuid <- "2c77b1cdf33dbed3dbfb74e4b578300e"
dataset_derived(uuid)
uuid <- "564167adbbb2fdd64c24e7ea409c23f1"
dataset_metadata(uuid)

uuid <- "564167adbbb2fdd64c24e7ea409c23f1"
dataset_contributors(uuid)

}
