% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxMthdAssign.R, R/gtoxMthdClear.R,
%   R/gtoxMthdList.R, R/gtoxMthdLoad.R, R/mthd_funcs.R
\name{gtoxMthdAssign}
\alias{gtoxMthdAssign}
\alias{gtoxMthdClear}
\alias{gtoxMthdList}
\alias{gtoxMthdLoad}
\alias{Method functions}
\title{Functions for managing processing methods}
\usage{
gtoxMthdAssign(lvl, id, mthd_id, ordr = NULL, type)

gtoxMthdClear(lvl, id, mthd_id = NULL, type)

gtoxMthdList(lvl, type = "mc")

gtoxMthdLoad(lvl, id = NULL, type = "mc")
}
\arguments{
\item{lvl}{Integer of length 1, the method level}

\item{id}{Integer, the assay component or assay endpoint id(s)}

\item{mthd_id}{Integer, the method id(s)}

\item{ordr}{Integer, the order in which to execute the analysis methods,
must be the same length as mthd_id, does not apply to levels 5 or 6}

\item{type}{Character of length 1, the data type, "sc" or "mc"}
}
\value{
None
}
\description{
These functions are used to manage which methods are used to process data.
They include methods for assigning, clearing, and loading the assigned 
methods. Also, \code{gtoxMthdList} lists the available methods.
}
\details{
\code{gtoxMthdLoad} loads the assigned methods for the given level and 
ID(s). Similarly, \code{gtoxMthdList} displays the available methods for 
the given level. These two functions do not make any changes to the 
database.

Unlike the \code{-Load} and \code{-List} functions, the \code{-Assign} and 
\code{-Clear} functions alter the database and trigger a delete cascade. 
\code{gtoxMthdAssign} assigns methods to the given ID(s), and 
\code{gtoxMthdClear} removes methods. In addition to the method ID 
('mthd_id'), assigning methods at some levels require an order ('ordr'). 
The 'ordr' parameter is necessary to allow progression of methods at level
one for single-concentration processing, and levels two and three for 
multiple-concentration processing. More information about method assignments 
and the delete cascade are available in the package vignette.
}
\examples{

\dontrun{
## Assign level 2 methods (none for all acid values)
gtoxMthdAssign(lvl = 2L, id = 1L, mthd_id = 1, ordr = 1, type = "mc")

## Process data
gtoxRun(asid = 1L, slvl = 1, elvl = 6, mc.cores = 2)
}


\dontrun{
## Clear level 2 methods
gtoxMthdClear(lvl = 2L, id = 1L, mthd_id = NULL, type = "mc") 

## Assign level 2 methods (none for all acid values)
gtoxMthdAssign(lvl = 2L, id = 1L, mthd_id = 1, ordr = 1, type = "mc")

## Process data
gtoxRun(asid = 1L, slvl = 1, elvl = 6, mc.cores = 2)
}

## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## gtoxListMthd allows the user to display the available methods for 
## a given level and data type
head(gtoxMthdList(lvl = 2, type = "mc"))

## gtoxLoadMthd shows which methods are assigned for the given ID, level,
## and data type. Here we will show how to register, load, and clear methods
## using an acid not in the example database. Note: There is no check for
## whether an ID exists before assigning/clearing methods. 
gtoxMthdLoad(lvl = 2, id = 1, type = "mc")

## Reset configuration
options(conf_store)

}
