% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadAnnot.R
\name{loadAnnot}
\alias{loadAnnot}
\title{Register the annotations provided by GUI}
\usage{
loadAnnot(plate, assay, outFile = "out.json")
}
\arguments{
\item{plate}{path to 'plate' JSON file produced by the GUI}

\item{assay}{path to 'assay' JSON file produced by the GUI}

\item{outFile}{character of length 1, name of the output file}
}
\value{
Logical value
}
\description{
This function parses the output from the GUI and registers the
appropriate data within the GladiaTOX database.
}
\details{
If loading legacy data, 'outFile' should be set to NULL and no JSON file
will be written.
}
\examples{

\dontrun{
## Load sample data
load(system.file("extdata", "data_for_vignette.rda", package="GladiaTOX"))

## Build assay table
assay <- buildAssayTab(plate, chnmap)

## Set study parameters
std.nm <- "SampleStudy" # study name
phs.nm <- "PhaseII" # study phase

## Delete previously loaded study data
asid = gtoxLoadAsid(fld=c("asnm", "asph"), val=list(std.nm, phs.nm))$asid
if(length(asid)>0){ deleteStudy(asid=asid) }

## Load annotation in gtoxDB
loadAnnot(plate, assay, NULL)
}

}
