% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc4.R
\name{mc4}
\alias{mc4}
\title{Perform level 4  
multiple-concentration processing}
\usage{
mc4(ae, wr = FALSE)
}
\arguments{
\item{ae}{Integer of length 1, assay endpoint id (aeid) for processing.}

\item{wr}{Logical, whether the processed data should be written to the gtox
database}
}
\value{
A boolean of length 1, indicating the success of the processing, or 
when 'wr' is FALSE, a list where the first element is a boolean indiciating 
the success of processing and the second element is a data.table containing 
the processed data
}
\description{
\code{mc4} loads level 3 data from the gtox 
database for the given id and performs level 4 
multiple-concentration processing. 
The processed data is then loaded into the mc4 table and 
all subsequent data is deleted with \code{\link{gtoxCascade}}. See details 
for more information.

The individual processing functions are no longer exported, as it is 
typically more convenient and suggested to use the \code{\link{gtoxRun}} 
wrapper function.
}
\details{
Level 4 multiple-concentration modeling takes the dose-response data for
chemical-assay pairs, and fits three models to the data: constant, hill,
and gain-loss. For more information about the models see
\code{\link{Models}}. When a chemical has more than one sample, the function
fits each sample seperately.
}
\seealso{
\code{\link{gtoxFit}}, \code{\link{Models}}

Other multiple-concentration data 
processing functions: \code{\link{mc1}},
  \code{\link{mc2}}, \code{\link{mc3}}, \code{\link{mc5}},
  \code{\link{mc6}}
}
\concept{multiple-concentration data 
processing functions}
\keyword{internal}
