% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExploreModelMatrix.R
\name{ExploreModelMatrix}
\alias{ExploreModelMatrix}
\title{Explore model matrix}
\usage{
ExploreModelMatrix(
  sampleData = NULL,
  designFormula = NULL,
  addStopButton = TRUE
)
}
\arguments{
\item{sampleData}{(optional) A \code{data.frame} or \code{DataFrame}
with sample information. If set to \code{NULL}, the user can upload
the sample information from a tab-separated text file inside the app, or
choose among a collection of example designs provided in the app.}

\item{designFormula}{(optional) A \code{formula}. All components of
the terms must be present as columns in \code{sampleData}. If set to
\code{NULL}, the design formula can be specified after launching the app.}

\item{addStopButton}{Logical scalar. If \code{TRUE} (default), will add a
button to stop the app (by calling \code{shiny::stopApp}).}
}
\value{
A Shiny app object
}
\description{
Given a sample data table and a design formula, explore the
resulting design
matrix graphically in an interactive application.
}
\examples{
app <- ExploreModelMatrix(
  sampleData = data.frame(genotype = rep(c("A", "B"), each = 4),
                          treatment = rep(c("treated", "untreated"), 4)),
  designFormula = ~genotype + treatment
)
if (interactive()) shiny::runApp(app)

}
\author{
Charlotte Soneson, Federico Marini, Michael I Love, Florian Geier,
  Michael B Stadler
}
