% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ranges-helpers.R
\name{positionSequence}
\alias{positionSequence}
\alias{positionSequence,Ranges-method}
\alias{positionSequence,RangesList-method}
\alias{as.integer,Ranges-method}
\title{Generate integer sequences from position information of \code{Ranges}}
\usage{
positionSequence(x, order = FALSE, decreasing = FALSE)

\S4method{positionSequence}{Ranges}(x, order = FALSE, decreasing = FALSE)

\S4method{positionSequence}{RangesList}(x, order = FALSE, decreasing = FALSE)

\S4method{as.integer}{Ranges}(x)
}
\arguments{
\item{x}{a \code{Ranges} object, like a
\code{\link[GenomicRanges:GRanges-class]{GRanges}} or
\code{\link[IRanges:IRanges-class]{IRanges}}, or a \code{RangesList}
object, like a \code{\link[GenomicRanges:GRangesList-class]{GRangesList}}
or \code{\link[IRanges:IRangesList-class]{IRangesList}}}

\item{order}{\code{TRUE} or \code{FALSE}: Should the position be ordered?
(default: \code{order = FALSE})}

\item{decreasing}{\code{TRUE} or \code{FALSE}: If \code{order = TRUE} Should
the position be ordered in a decreasing order? (default: \code{order =
FALSE})}
}
\value{
a \code{integer} vector if x is a
  \code{\link[GenomicRanges:GRanges-class]{GRanges}} object and a
  \code{IntegerList} if x is a
  \code{\link[GenomicRanges:GRangesList-class]{GRangesList}}
}
\description{
\code{positionSequence} generates sequences of integer values
along the range information of \code{x}. This can be used for navigating
specific positions on a range information.
}
\examples{
library(GenomicRanges)
# Returns an integer vector
gr <- GRanges("chr1:1-5:+")
positionSequence(gr)
gr2 <- GRanges("chr1:1-5:-")
positionSequence(gr)
# returns an IntegerList
grl <- GRangesList("1" = gr,"2" = gr,"3" = gr2) # must be named
positionSequence(grl)
}
