% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merged_ewce.r
\name{merged_ewce}
\alias{merged_ewce}
\title{Multiple EWCE results from multiple studies}
\usage{
merged_ewce(results, reps = 100)
}
\arguments{
\item{results}{a list of EWCE results generated using
\link[EWCE]{add_res_to_merging_list}.}

\item{reps}{Number of random gene lists to generate (Default=100 but should
be >=10,000 for publication-quality results).}
}
\value{
dataframe in which each row gives the statistics (p-value, fold
change and number of standard deviations from the mean) associated with the
enrichment of the stated cell type in the gene list.
}
\description{
\code{merged_ewce} combines enrichment results from multiple studies
targetting the same scientific problem
}
\examples{
# Load the single cell data
ctd <- ewceData::ctd()

# Use 3 bootstrap lists for speed, for publishable analysis use >10000
reps <- 3
# Use 5 up/down regulated genes (thresh) for speed, default is 250
thresh <- 5

# Load the data
tt_alzh_BA36 <- ewceData::tt_alzh_BA36()
tt_alzh_BA44 <- ewceData::tt_alzh_BA44()

# Run EWCE analysis
tt_results_36 <- EWCE::ewce_expression_data(
    sct_data = ctd,
    tt = tt_alzh_BA36,
    thresh = thresh,
    annotLevel = 1,
    reps = reps,
    ttSpecies = "human",
    sctSpecies = "mouse"
)
tt_results_44 <- EWCE::ewce_expression_data(
    sct_data = ctd,
    tt = tt_alzh_BA44,
    thresh = thresh,
    annotLevel = 1,
    reps = reps,
    ttSpecies = "human",
    sctSpecies = "mouse"
)

# Fill a list with the results
results <- EWCE::add_res_to_merging_list(tt_results_36)
results <- EWCE::add_res_to_merging_list(tt_results_44, results)

# Perform the merged analysis
# For publication reps should be higher
merged_res <- EWCE::merged_ewce(
    results = results,
    reps = 2
)
print(merged_res)
}
