% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_sce.R
\name{merge_sce}
\alias{merge_sce}
\title{Merge multiple \code{SingleCellExperiment} objects}
\source{
\href{https://bioconductor.org/packages/release/bioc/html/scMerge.html}{
scMerge}.
}
\usage{
merge_sce(
  sce_list,
  method = "intersect",
  cut_off_batch = 0.01,
  cut_off_overall = 0.01,
  use_assays = NULL,
  colData_names = NULL,
  batch_names = NULL,
  verbose = TRUE
)
}
\arguments{
\item{sce_list}{A list contains the \code{SingleCellExperiment}
Object from each batch.}

\item{method}{A string indicates the method of combining the
gene expression matrix, either \code{union} or \code{intersect}.
 Default to \code{intersect}. \code{union} only supports matrix class.}

\item{cut_off_batch}{A numeric vector indicating the cut-off for
the proportion of a gene is expressed within each batch.}

\item{cut_off_overall}{A numeric vector  indicating the cut-off for
the proportion of a gene is expressed overall data.}

\item{use_assays}{A string vector indicating the expression matrices
to be combined.
The first assay named will be used to determine the proportion of zeros.}

\item{colData_names}{A string vector indicating the \code{colData}
that are combined.}

\item{batch_names}{A string vector indicating the batch names for
the output SCE object.}

\item{verbose}{Print messages.}
}
\value{
A \code{SingleCellExperiment} object with the list of SCE
objects combined.
}
\description{
Merge several \code{SingleCellExperiment} (SCE) objects from
different batches/experiments.
Extracted from the
\href{https://bioconductor.org/packages/release/bioc/html/scMerge.html}{
scMerge} package.
}
\examples{
ctd <- ewceData::ctd()
sce_list <- EWCE::ctd_to_sce(object = ctd)
sce_combine <- merge_sce(sce_list = sce_list)
}
\author{
Yingxin Lin (modified by Brian Schilder)
}
