% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_ctd.R
\name{merge_ctd}
\alias{merge_ctd}
\title{Merge multiple CellTypeDataset references}
\usage{
merge_ctd(
  CTD_list,
  save_dir = tempdir(),
  standardise_CTD = FALSE,
  as_SCE = FALSE,
  gene_union = TRUE,
  merge_levels = seq(1, 5),
  save_split_SCE = FALSE,
  save_split_CTD = FALSE,
  save_merged_SCE = TRUE,
  force_new_quantiles = FALSE,
  numberOfBins = 40,
  as_sparse = TRUE,
  as_DelayedArray = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{CTD_list}{(Named) list of \code{CellTypeDatasets}.}

\item{save_dir}{The directory to save merged files in.}

\item{standardise_CTD}{Whether to run \code{standardise_ctd}.}

\item{as_SCE}{If \code{TRUE} (default), 
returns the merged results as a named list of 
\link[SingleCellExperiment]{SingleCellExperiment}s.
If \code{FALSE}, returns as a CTD object.}

\item{gene_union}{Whether to take the gene union or intersection
when merging matrices (mean_exp,specificity, etc.).}

\item{merge_levels}{Which CTD levels you want to merge.
Can be a single value (e.g. \code{merge_levels=5})
or a list c(e.g. \code{merge_levels=c(1:5)}).
If some CTD don't have the same number of levels,
the maximum level depth available in that CTD will be used instead.}

\item{save_split_SCE}{Whether to save individual SCE files
in the subdirectory \emph{standardized_CTD_SCE}.}

\item{save_split_CTD}{Whether to save individual CTD files
in the subdirectory \emph{standardized_CTD}.}

\item{save_merged_SCE}{Save the final merged SCE object, or simply 
to return it.}

\item{force_new_quantiles}{If specificity quantiles matrix already exists,
create a new one.}

\item{numberOfBins}{Number of bins to compute specificity quantiles with.}

\item{as_sparse}{Convert matrices to sparse matrix.}

\item{as_DelayedArray}{Convert matrices to \code{DelayedArray}.}

\item{verbose}{Print messages.}

\item{...}{Additional arguments to be passed to \code{standardise_ctd}.}
}
\value{
List of CellTypeDatasets or SingleCellExperiments.
}
\description{
Import CellTypeDataset (CTD) references from a remote repository,
standardize each, and then merge into one CTD.
Optionally, can return these as a merged
 \link[SingleCellExperiment]{SingleCellExperiment}.
}
\examples{
## Let's pretend these are different CTD datasets
ctd1 <- ewceData::ctd()
ctd2 <- ctd1
CTD_list <- list(ctd1, ctd2)
CTD_merged <- EWCE::merge_ctd(CTD_list = CTD_list)
}
