% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_variance_quantiles.r
\name{filter_variance_quantiles}
\alias{filter_variance_quantiles}
\title{Filter variance quantiles}
\usage{
filter_variance_quantiles(
  exp,
  log10_norm = TRUE,
  n_quantiles = 10,
  min_variance_quantile = as.integer(n_quantiles/2),
  verbose = TRUE
)
}
\arguments{
\item{exp}{Gene expression matrix.}

\item{log10_norm}{Log10-normalise \code{exp} before computing variance.}

\item{n_quantiles}{Number of quantile bins to use.
Defaults to deciles (\code{n_quantiles=10}).}

\item{min_variance_quantile}{The minimum variance quantile
to keep values from.}

\item{verbose}{Print messages.}
}
\value{
Filtered \code{exp}.
}
\description{
Remove rows in \code{exp} that do not vary substantially across rows.
}
\keyword{internal}
