% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_bootstrap_results.R
\name{example_bootstrap_results}
\alias{example_bootstrap_results}
\title{Example bootstrap enrichment results}
\source{
# Load the single cell data

ctd <- ewceData::ctd()

# Set the parameters for the analysis

# Use 3 bootstrap lists for speed, for publishable analysis use >=10,000

reps <- 3

# Load gene list from Alzheimer's disease GWAS

example_genelist <- ewceData::example_genelist()

# Bootstrap significance test, no control for transcript length or GC content

full_results <- EWCE::bootstrap_enrichment_test(
    sct_data = ctd,
    hits = example_genelist,
    reps = reps,
    annotLevel = 1,
    sctSpecies = "mouse",
    genelistSpecies = "human"
)

bootstrap_results <- full_results

save(bootstrap_results,file = "inst/extdata/bootstrap_results.rda")
}
\usage{
example_bootstrap_results(verbose = TRUE, localHub = FALSE)
}
\arguments{
\item{verbose}{Print messages.}

\item{localHub}{If working offline, add argument localHub=TRUE to work 
with a local, non-updated hub; It will only have resources available that
have previously been downloaded. If offline, Please also see BiocManager
vignette section on offline use to ensure proper functionality.}
}
\value{
List with 3 items.
}
\description{
Example cell type enrichment
results produced by \link[EWCE]{bootstrap_enrichment_test}.
}
\examples{
full_results <- example_bootstrap_results()
}
