% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ewce_plot.r
\name{ewce_plot}
\alias{ewce_plot}
\title{Plot EWCE results}
\usage{
ewce_plot(
  total_res,
  mtc_method = "bonferroni",
  q_threshold = 0.05,
  ctd = NULL,
  annotLevel = 1,
  heights = c(0.3, 1),
  make_dendro = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{total_res}{Results data.frame generated using
\link[EWCE]{bootstrap_enrichment_test} or
\link[EWCE]{ewce_expression_data} functions.
Multiple results tables can be
merged into one results table, as long as the 'list' column is set to
distinguish them.
Multiple testing correction is then applied across all merged results.}

\item{mtc_method}{Method to be used for multiple testing correction.
Argument is passed to \link[stats]{p.adjust} (DEFAULT: "bonferroni).}

\item{q_threshold}{Corrected significance threshold.}

\item{ctd}{CellTypeDataset object.
Should be provided so that the dendrogram can be taken from it
and added to plots.}

\item{annotLevel}{An integer indicating which level of \code{ctd} to
analyse (\emph{Default: 1}).}

\item{heights}{The relative heights row in the grid.
Will get repeated to match the dimensions of the grid.
Passed to \link[patchwork]{wrap_plots}.}

\item{make_dendro}{Add a dendrogram (requires \code{ctd}).}

\item{verbose}{Print messages.}
}
\value{
A named list containing versions of the \link[ggplot2]{ggplot}
 with and without the dendrogram. Note that cell type order on the x-axis is
 based on hierarchical clustering for both plots if make_dendro = TRUE.
}
\description{
\code{ewce_plot} generates plots of EWCE enrichment results
}
\examples{
## Bootstrap significance test,
##  no control for transcript length or GC content
## Use pre-computed results to speed up example
total_res <- EWCE::example_bootstrap_results()$results
plt <- ewce_plot(total_res = total_res)
}
