% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_args_for_bootstrap_plot_generation.R
\name{check_args_for_bootstrap_plot_generation}
\alias{check_args_for_bootstrap_plot_generation}
\title{check_args_for_bootstrap_plot_generation}
\usage{
check_args_for_bootstrap_plot_generation(
  sct_data,
  tt,
  thresh,
  annotLevel,
  reps,
  full_results,
  listFileName,
  showGNameThresh,
  sortBy
)
}
\arguments{
\item{sct_data}{List generated using \link[EWCE]{generate_celltype_data}.}

\item{tt}{Differential expression table.
Can be output of \link[limma]{topTable} function.
Minimum requirement is that one column stores a metric of
increased/decreased expression (i.e. log fold change, t-statistic for
differential expression etc) and another contains gene symbols.}

\item{thresh}{The number of up- and down- regulated genes to be included in
each analysis (Default: 250).}

\item{annotLevel}{An integer indicating which level of \code{sct_data} to
analyse (\emph{Default: 1}).}

\item{reps}{Number of random gene lists to generate (\emph{Default: 100},
but should be >=10,000 for publication-quality results).}

\item{full_results}{The full output of
\link[EWCE]{ewce_expression_data} for the same gene list.}

\item{listFileName}{String used as the root for files saved using
this function.}

\item{showGNameThresh}{Integer. If a gene has over X percent of it's
expression proportion in a cell type, then list the gene name.}

\item{sortBy}{Column name of metric in \code{tt}
which should be used to sort up- from down- regulated genes (Default: "t").}
}
\value{
Null output.
}
\description{
Check the input arguments of the 
\link[EWCE]{generate_bootstrap_plots_for_transcriptome}.
}
\keyword{internal}
