% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{plot_pileUp_multisample}
\alias{plot_pileUp_multisample}
\title{Get a list of pile-up plots over multiple samples}
\usage{
plot_pileUp_multisample(
  result,
  X_raw,
  target_indices = NULL,
  plot_target = "x",
  gff3_fn,
  baseline = 1,
  annot_margin = 0.01,
  arrow_spacing = 0.05,
  geme_name_space = 0.5,
  col_pal = col_yarrr_info2,
  col_cn_baseline = "#708C98",
  col_pal_cn = col_yarrr_info2[-5],
  exclude_genes = NULL,
  annot_plot_ratio = 0.3
)
}
\arguments{
\item{result}{analysis result}

\item{X_raw}{input raw depth matrix}

\item{target_indices}{sample indices to plot}

\item{plot_target}{target data type to plot (Default : \code{"x"})}

\item{gff3_fn}{gene annotation file name}

\item{baseline}{the state index to set as baseline (Default : \code{1})}

\item{annot_margin}{minimum of margin between gene annotations allowed. As a fraction of plotting area. (Default : \code{0.01})}

\item{arrow_spacing}{gene annotation arrow spacing. As a fraction of plotting area. (Default : \code{0.05})}

\item{geme_name_space}{the height of white space reserved for gene names in the annotation. (Default : \code{0.5})}

\item{col_pal}{gene color palette}

\item{col_cn_baseline}{color for baseline (Default : \code{"#708C98"})}

\item{col_pal_cn}{color palette for non-baseline copy number states}

\item{exclude_genes}{name of genes to exclude from the annotation track (Default : NULL)}

\item{annot_plot_ratio}{ratio of the annotation plot under the pileup plot}
}
\value{
a list of pile-up ggplot object
}
\description{
Get a list of pile-up plots over multiple samples
}
\examples{

# gff3 gene model file
package_name <- "ELViS"
gff3_fn <- system.file("extdata","HPV16REF_PaVE.gff",package = package_name)

# loading precalculated depth matrix
data(mtrx_samtools_reticulate)

# threshold
th <- 50

# filtered matrix
base_resol_depth <- filt_samples(mtrx_samtools_reticulate,th=th,smry_fun=max)

data(ELViS_toy_run_result)
result <- ELViS_toy_run_result

# get line plots for shape-change samples
gg_lst_x <-
plot_pileUp_multisample(
  result = result,
  X_raw = base_resol_depth,
  plot_target = "x",
  gff3 = gff3_fn,
  baseline=1,
  exclude_genes = c("E6*","E1^E4","E8^E2"),
  target_indices = result$final_call$cnv_samples[seq_len(3)]
  )

gg_lst_x[[1]]



}
